/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.verifier.jaxp.validation;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierHandler;
import org.iso_relax.verifier.impl.ForkContentHandler;
import org.iso_relax.verifier.jaxp.validation.EntityResolverImpl;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class ValidatorImpl
extends Validator {
    private final Verifier verifier;
    private ErrorHandler errorHandler;
    private LSResourceResolver resourceResolver;
    private Transformer idTrans;

    ValidatorImpl(Verifier verifier) {
        this.verifier = verifier;
    }

    private Transformer getIdentitiyTransformer() {
        if (this.idTrans == null) {
            try {
                this.idTrans = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new InternalError();
            }
        }
        return this.idTrans;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate(Source source, Result result) throws SAXException, IOException {
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            if (result != null) {
                throw new IllegalArgumentException();
            }
            InputSource is = new InputSource();
            is.setByteStream(ss.getInputStream());
            is.setCharacterStream(ss.getReader());
            is.setSystemId(ss.getSystemId());
            is.setPublicId(ss.getPublicId());
            this.verifier.verify(is);
            return;
        } else if (source instanceof DOMSource) {
            DOMSource ds = (DOMSource)source;
            this.verifier.verify(ds.getNode());
            if (result == null) return;
            try {
                this.getIdentitiyTransformer().transform(source, result);
                return;
            }
            catch (TransformerException e) {
                throw new SAXException(e);
            }
        } else {
            if (!(source instanceof SAXSource)) throw new IllegalArgumentException();
            SAXSource ss = (SAXSource)source;
            XMLReader r = ss.getXMLReader();
            if (r == null) {
                r = XMLReaderFactory.createXMLReader();
            }
            VerifierHandler h = this.verifier.getVerifierHandler();
            if (result instanceof SAXResult) {
                SAXResult sr = (SAXResult)result;
                h = new ForkContentHandler((ContentHandler)h, sr.getHandler());
            }
            r.setContentHandler((ContentHandler)h);
            if (ss.getInputSource() != null) {
                r.parse(ss.getInputSource());
                return;
            } else {
                if (ss.getSystemId() == null) throw new IllegalArgumentException();
                r.parse(ss.getSystemId());
            }
        }
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.verifier.setErrorHandler(errorHandler);
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.verifier.setEntityResolver((EntityResolver)new EntityResolverImpl(resourceResolver));
        this.resourceResolver = resourceResolver;
    }

    @Override
    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @Override
    public void reset() {
        this.setErrorHandler(null);
        this.setResourceResolver(null);
    }
}

