/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.h2;

import java.sql.SQLException;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.h2.H2Database;
import org.jooq.meta.h2.information_schema.Tables;
import org.jooq.tools.StringUtils;
import org.jooq.util.h2.H2DataType;

public class H2RoutineDefinition
extends AbstractRoutineDefinition {
    private final String specificName;

    public H2RoutineDefinition(SchemaDefinition schema, String name, String specificName, String dataType, Number precision, Number scale, String comment, String overload) {
        super(schema, null, name, comment, overload);
        if (!StringUtils.isBlank((String)dataType)) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, dataType, precision, precision, scale, null, null);
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
        this.specificName = specificName;
    }

    @Override
    protected void init0() throws SQLException {
        if (((H2Database)this.getDatabase()).is2_0_202()) {
            this.init2_0();
        } else {
            this.init1_4();
        }
    }

    private void init2_0() {
        Result result = this.create().select(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.PARAMETER_MODE, org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.PARAMETER_NAME, (SelectField)DSL.nvl((Field)DSL.concat((Field[])new Field[]{org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.DATA_TYPE, DSL.inline((String)" ARRAY")}), org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.DATA_TYPE).as(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.DATA_TYPE), (SelectField)DSL.nvl(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.CHARACTER_MAXIMUM_LENGTH, org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH).as(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH), (SelectField)DSL.nvl(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.NUMERIC_PRECISION, org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.NUMERIC_PRECISION).as(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.NUMERIC_PRECISION), (SelectField)DSL.nvl(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.NUMERIC_SCALE, org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.NUMERIC_SCALE).as(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.NUMERIC_SCALE), org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.ORDINAL_POSITION).from((TableLike)org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS).join((TableLike)org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES).on(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.SPECIFIC_SCHEMA.eq(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.SPECIFIC_SCHEMA)).and(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.SPECIFIC_NAME.eq(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.SPECIFIC_NAME)).leftJoin((TableLike)org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES).on(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.SPECIFIC_SCHEMA.eq(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.OBJECT_SCHEMA)).and(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.SPECIFIC_NAME.eq(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.OBJECT_NAME)).and(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.DTD_IDENTIFIER.eq(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER)).where(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.SPECIFIC_SCHEMA.eq((Object)this.getSchema().getName())).and(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.SPECIFIC_NAME.eq((Object)this.specificName)).orderBy((OrderField)org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.ORDINAL_POSITION.asc()).fetch();
        for (Record record : result) {
            String inOut = (String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.PARAMETER_MODE);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.DATA_TYPE), (Number)record.get(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.NUMERIC_PRECISION), (Number)record.get(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.NUMERIC_SCALE), null, null);
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, ((String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.PARAMETER_NAME)).replaceAll("@", ""), (Integer)record.get(org.jooq.meta.hsqldb.information_schema.Tables.PARAMETERS.ORDINAL_POSITION, Integer.TYPE), type);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }

    private void init1_4() {
        for (Record record : this.create().select(Tables.FUNCTION_COLUMNS.COLUMN_NAME, Tables.FUNCTION_COLUMNS.TYPE_NAME, Tables.FUNCTION_COLUMNS.PRECISION, Tables.FUNCTION_COLUMNS.SCALE, Tables.FUNCTION_COLUMNS.POS, Tables.FUNCTION_COLUMNS.NULLABLE, Tables.FUNCTION_COLUMNS.COLUMN_DEFAULT).from((TableLike)Tables.FUNCTION_COLUMNS).where(Tables.FUNCTION_COLUMNS.ALIAS_SCHEMA.equal((Object)this.getSchema().getName())).and(Tables.FUNCTION_COLUMNS.ALIAS_NAME.equal((Object)this.getName())).and(Tables.FUNCTION_COLUMNS.POS.gt((Object)0)).and(this.getOverload() == null ? DSL.noCondition() : Tables.FUNCTION_COLUMNS.COLUMN_COUNT.eq((Object)((Integer)Tables.FUNCTION_COLUMNS.COLUMN_COUNT.getDataType().convert((Object)this.getOverload())))).orderBy((OrderField)Tables.FUNCTION_COLUMNS.POS.asc()).fetch()) {
            String paramName = (String)record.get(Tables.FUNCTION_COLUMNS.COLUMN_NAME);
            String typeName = (String)record.get(Tables.FUNCTION_COLUMNS.TYPE_NAME);
            Integer precision = (Integer)record.get(Tables.FUNCTION_COLUMNS.PRECISION);
            Short scale = (Short)record.get(Tables.FUNCTION_COLUMNS.SCALE);
            int position = (Integer)record.get(Tables.FUNCTION_COLUMNS.POS);
            boolean nullable = (Boolean)record.get(Tables.FUNCTION_COLUMNS.NULLABLE, Boolean.TYPE);
            String defaultValue = (String)record.get(Tables.FUNCTION_COLUMNS.COLUMN_DEFAULT);
            if (position == 0 && H2DataType.OTHER.getTypeName().equalsIgnoreCase(typeName)) continue;
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), typeName, precision, precision, scale, nullable, defaultValue);
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, paramName, position, type);
            this.addParameter(InOutDefinition.IN, parameter);
        }
    }
}

