/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jooq.meta.AbstractConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DefaultInverseForeignKeyDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.InverseForeignKeyDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;

public class DefaultForeignKeyDefinition
extends AbstractConstraintDefinition
implements ForeignKeyDefinition {
    private final List<ColumnDefinition> fkColumns = new ArrayList<ColumnDefinition>();
    private final List<ColumnDefinition> ukColumns = new ArrayList<ColumnDefinition>();
    private final UniqueKeyDefinition uk;

    public DefaultForeignKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, UniqueKeyDefinition uniqueKey) {
        this(schema, name, table, uniqueKey, true);
    }

    public DefaultForeignKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, UniqueKeyDefinition uk, boolean enforced) {
        super(schema, table, name, enforced);
        this.uk = uk;
    }

    @Override
    public TableDefinition getKeyTable() {
        return this.getTable();
    }

    @Override
    public List<ColumnDefinition> getKeyColumns() {
        return this.fkColumns;
    }

    @Override
    public UniqueKeyDefinition getReferencedKey() {
        return this.uk;
    }

    @Override
    public UniqueKeyDefinition resolveReferencedKey() {
        return this.uk.resolveReferencedKey();
    }

    @Override
    public TableDefinition getReferencedTable() {
        return this.uk.getTable();
    }

    @Override
    public List<ColumnDefinition> getReferencedColumns() {
        return this.ukColumns;
    }

    @Override
    public int countSimilarReferences() {
        HashSet<String> keys = new HashSet<String>();
        for (ForeignKeyDefinition key : this.getDatabase().getRelations().getForeignKeys(this.getTable())) {
            if (!key.getReferencedTable().equals(this.getReferencedTable())) continue;
            keys.add(key.getName());
        }
        return keys.size();
    }

    @Override
    public InverseForeignKeyDefinition getInverse() {
        return new DefaultInverseForeignKeyDefinition(this);
    }
}

