/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.Definition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.tools.StringUtils;

public abstract class AbstractDefinition
implements Definition {
    private final Database database;
    private final SchemaDefinition schema;
    private final PackageDefinition pkg;
    private final String name;
    private final String schemaComment;
    private final String overload;
    private final String source;
    private transient String qualifiedInputName;
    private transient String qualifiedOutputName;
    private transient Name qualifiedInputNamePart;
    private transient Name qualifiedOutputNamePart;
    private transient Integer hashCode;

    public AbstractDefinition(Database database, SchemaDefinition schema, String name) {
        this(database, schema, name, null);
    }

    public AbstractDefinition(Database database, SchemaDefinition schema, String name, String comment) {
        this(database, schema, name, comment, null);
    }

    public AbstractDefinition(Database database, SchemaDefinition schema, String name, String comment, String overload) {
        this(database, schema, null, name, comment, overload);
    }

    public AbstractDefinition(Database database, SchemaDefinition schema, PackageDefinition pkg, String name, String comment, String overload) {
        this(database, schema, pkg, name, comment, overload, null);
    }

    public AbstractDefinition(Database database, SchemaDefinition schema, PackageDefinition pkg, String name, String comment, String overload, String source) {
        this.database = database;
        this.schema = schema == null && this instanceof SchemaDefinition ? (SchemaDefinition)this : schema;
        this.pkg = pkg;
        this.name = name;
        this.overload = overload;
        this.source = source;
        this.schemaComment = comment;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>(this.getSchema().getDefinitionPath());
        if (this.getPackage() != null) {
            result.add(this.getPackage());
        }
        result.add(this);
        return result;
    }

    @Override
    public final PackageDefinition getPackage() {
        return this.pkg;
    }

    @Override
    public final String getOverload() {
        return this.overload;
    }

    @Override
    public CatalogDefinition getCatalog() {
        return this.getSchema().getCatalog();
    }

    @Override
    public final SchemaDefinition getSchema() {
        return this.schema;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getInputName() {
        return this.name;
    }

    @Override
    public String getOutputName() {
        return this.getInputName();
    }

    @Override
    public final String getComment() {
        return this.getSchemaComment();
    }

    private final String getSchemaComment() {
        return !StringUtils.isEmpty((String)this.schemaComment) ? this.schemaComment : (String)StringUtils.defaultIfNull((Object)this.getDatabase().getComments().get(this), (Object)"");
    }

    @Override
    public final String getQualifiedName() {
        return this.getQualifiedInputName();
    }

    @Override
    public final String getQualifiedInputName() {
        if (this.qualifiedInputName == null) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (Definition part : this.getDefinitionPath()) {
                String input = part.getInputName();
                if (StringUtils.isEmpty((String)input)) continue;
                sb.append(separator);
                sb.append(part.getInputName());
                separator = ".";
            }
            this.qualifiedInputName = sb.toString();
        }
        return this.qualifiedInputName;
    }

    @Override
    public final String getQualifiedOutputName() {
        if (this.qualifiedOutputName == null) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (Definition part : this.getDefinitionPath()) {
                if (part instanceof CatalogDefinition && ((CatalogDefinition)part).isDefaultCatalog() || part instanceof SchemaDefinition && ((SchemaDefinition)part).isDefaultSchema()) continue;
                sb.append(separator);
                sb.append(part.getOutputName());
                separator = ".";
            }
            this.qualifiedOutputName = sb.toString();
        }
        return this.qualifiedOutputName;
    }

    @Override
    public final Name getQualifiedNamePart() {
        return this.getQualifiedInputNamePart();
    }

    @Override
    public final Name getQualifiedInputNamePart() {
        if (this.qualifiedInputNamePart == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (Definition part : this.getDefinitionPath()) {
                list.add(part.getInputName());
            }
            this.qualifiedInputNamePart = DSL.name(list);
        }
        return this.qualifiedInputNamePart;
    }

    @Override
    public final Name getQualifiedOutputNamePart() {
        if (this.qualifiedOutputNamePart == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (Definition part : this.getDefinitionPath()) {
                if (part instanceof CatalogDefinition && ((CatalogDefinition)part).isDefaultCatalog() || part instanceof SchemaDefinition && ((SchemaDefinition)part).isDefaultSchema()) continue;
                list.add(part.getOutputName());
            }
            this.qualifiedOutputNamePart = DSL.name(list);
        }
        return this.qualifiedOutputNamePart;
    }

    @Override
    public final Database getDatabase() {
        return this.database;
    }

    protected final Connection getConnection() {
        return this.database.getConnection();
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Definition) {
            Definition that = (Definition)obj;
            return that.getQualifiedName().equals(this.getQualifiedName());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getQualifiedName().hashCode();
        }
        return this.hashCode;
    }

    protected final DSLContext create() {
        return this.database.create();
    }

    protected final DSLContext create(boolean muteExceptions) {
        if (this.database instanceof AbstractDatabase) {
            return ((AbstractDatabase)this.database).create(muteExceptions);
        }
        return this.database.create();
    }

    protected final SQLDialect getDialect() {
        return this.database.getDialect();
    }

    @Override
    public final String getSource() {
        return this.source != null ? this.source : this.getDatabase().getSources().get(this);
    }
}

