/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.mysql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.mysql.information_schema.Tables;

public class MySQLTableDefinition
extends AbstractTableDefinition {
    private static final Pattern COLUMN_TYPE = Pattern.compile("(\\w+)\\s*(\\(\\d+\\))?\\s*(unsigned)?");

    public MySQLTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public MySQLTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        for (Record record : this.create().select(Tables.COLUMNS.ORDINAL_POSITION, Tables.COLUMNS.COLUMN_NAME, Tables.COLUMNS.COLUMN_COMMENT, Tables.COLUMNS.COLUMN_TYPE, Tables.COLUMNS.DATA_TYPE, Tables.COLUMNS.IS_NULLABLE, Tables.COLUMNS.COLUMN_DEFAULT, Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH, this.getDatabase().exists(Tables.COLUMNS.DATETIME_PRECISION) ? DSL.coalesce(Tables.COLUMNS.NUMERIC_PRECISION, (Field[])new Field[]{Tables.COLUMNS.DATETIME_PRECISION}).as(Tables.COLUMNS.NUMERIC_PRECISION) : Tables.COLUMNS.NUMERIC_PRECISION, Tables.COLUMNS.NUMERIC_SCALE, Tables.COLUMNS.EXTRA).from((TableLike)Tables.COLUMNS).where(Tables.COLUMNS.TABLE_SCHEMA.in((Object[])new String[]{this.getSchema().getName(), this.getSchema().getName()})).and(Tables.COLUMNS.TABLE_NAME.equal((Object)this.getName())).orderBy(Tables.COLUMNS.ORDINAL_POSITION)) {
            String columnType;
            Matcher matcher;
            String dataType = (String)record.get(Tables.COLUMNS.DATA_TYPE);
            boolean unsigned = this.getDatabase().supportsUnsignedTypes();
            boolean displayWidths = this.getDatabase().integerDisplayWidths();
            if ((unsigned || displayWidths) && Arrays.asList("tinyint", "smallint", "mediumint", "int", "bigint").contains(dataType.toLowerCase()) && (matcher = COLUMN_TYPE.matcher(columnType = ((String)record.get(Tables.COLUMNS.COLUMN_TYPE)).toLowerCase())).find()) {
                String mType = matcher.group(1);
                String mPrecision = matcher.group(2);
                String mUnsigned = matcher.group(3);
                dataType = mType + (unsigned && mUnsigned != null ? mUnsigned : "") + (displayWidths && mPrecision != null ? mPrecision : "");
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, (Number)record.get(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.COLUMNS.NUMERIC_PRECISION), (Number)record.get(Tables.COLUMNS.NUMERIC_SCALE), (Boolean)record.get(Tables.COLUMNS.IS_NULLABLE, Boolean.TYPE), (String)record.get(Tables.COLUMNS.COLUMN_DEFAULT), DSL.name((String[])new String[]{this.getSchema().getName(), this.getName() + "_" + (String)record.get(Tables.COLUMNS.COLUMN_NAME)}));
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(Tables.COLUMNS.COLUMN_NAME), result.size() + 1, (DataTypeDefinition)type, "auto_increment".equalsIgnoreCase((String)record.get(Tables.COLUMNS.EXTRA)), (String)record.get(Tables.COLUMNS.COLUMN_COMMENT)));
        }
        return result;
    }
}

