/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.CatalogDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.DomainDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.jdbc.JDBCTableDefinition;

public class JDBCDatabase
extends AbstractDatabase {
    private List<Schema> schemas;

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection());
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Schema schema : this.getSchemasFromMeta()) {
            SchemaDefinition s = this.getSchema(schema.getName());
            if (s == null) continue;
            for (Table table : schema.getTables()) {
                UniqueKey key;
                TableDefinition t = this.getTable(s, table.getName());
                if (t == null || (key = table.getPrimaryKey()) == null) continue;
                for (Field field : key.getFields()) {
                    ColumnDefinition c = t.getColumn(field.getName());
                    relations2.addPrimaryKey("PK_" + key.getTable().getName(), c);
                }
            }
        }
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (Schema schema : this.getSchemasFromMeta()) {
            result.add(new SchemaDefinition((Database)this, schema.getName(), ""));
        }
        return result;
    }

    private List<Schema> getSchemasFromMeta() {
        if (this.schemas == null) {
            this.schemas = new ArrayList<Schema>();
            for (Schema schema : this.create().meta().getSchemas()) {
                if (!this.getInputSchemata().contains(schema.getName())) continue;
                this.schemas.add(schema);
            }
        }
        return this.schemas;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Schema schema : this.getSchemasFromMeta()) {
            for (Sequence sequence : schema.getSequences()) {
                SchemaDefinition sd = this.getSchema(schema.getName());
                DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, sd, sequence.getDataType().getTypeName());
                result.add(new DefaultSequenceDefinition(sd, sequence.getName(), type));
            }
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Schema schema : this.getSchemasFromMeta()) {
            SchemaDefinition sd = this.getSchema(schema.getName());
            if (sd == null) continue;
            for (Table table : schema.getTables()) {
                result.add(new JDBCTableDefinition(sd, table));
            }
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }
}

