/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import org.jolokia.json.JSONArray;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;

public class ListExtractor
implements Extractor {
    @Override
    public Class<?> getType() {
        return List.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        String pathPart;
        List list = (List)pValue;
        int length = pConverter.getCollectionLength(list.size());
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            return this.extractWithPath(pConverter, list, pPathParts, jsonify, pathPart);
        }
        return jsonify ? this.extractListAsJson(pConverter, list, pPathParts, length) : list;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pIndex, Object pValue) throws IllegalAccessException, InvocationTargetException {
        int idx;
        List list = (List)pInner;
        try {
            idx = Integer.parseInt(pIndex);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Non-numeric index for accessing collection " + pInner + ". (index = " + pIndex + ", value to set = " + pValue + ")", exp);
        }
        Object oldValue = list.get(idx);
        Object value = oldValue != null ? pConverter.deserialize(oldValue.getClass().getName(), pValue) : pValue;
        list.set(idx, value);
        return oldValue;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    private Object extractWithPath(ObjectToJsonConverter pConverter, List<?> pList, Deque<String> pStack, boolean jsonify, String pPathPart) throws AttributeNotFoundException {
        try {
            int idx = Integer.parseInt(pPathPart);
            return pConverter.extractObject(pList.get(idx), pStack, jsonify);
        }
        catch (NumberFormatException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException((Throwable)new AttributeNotFoundException("Index '" + pPathPart + "' is not numeric for accessing list"));
        }
        catch (IndexOutOfBoundsException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException((Throwable)new AttributeNotFoundException("Index '" + pPathPart + "' is out-of-bound for a list of size " + pList.size()));
        }
    }

    private Object extractListAsJson(ObjectToJsonConverter pConverter, List<?> pList, Deque<String> pPath, int pLength) throws AttributeNotFoundException {
        JSONArray ret = new JSONArray(pLength);
        for (int i = 0; i < pLength; ++i) {
            LinkedList<String> path = new LinkedList<String>(pPath);
            try {
                ret.add(pConverter.extractObject(pList.get(i), path, true));
                continue;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {
                // empty catch block
            }
        }
        if (ret.isEmpty() && pLength > 0) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }
}

