/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;

public class BeanExtractor
implements Extractor {
    private static final Set<Class<?>> FINAL_CLASSES = new HashSet<Class>(Arrays.asList(String.class, Number.class, Byte.class, Double.class, Float.class, Long.class, Short.class, Integer.class, Boolean.class));
    private static final Set<String> IGNORE_METHODS = new HashSet<String>(Arrays.asList("getClass", "getStackTrace", "getClassLoader"));
    private static final Class[] IGNORED_RETURN_TYPES = new Class[]{OutputStream.class, Writer.class};
    private static final String[] GETTER_PREFIX = new String[]{"get", "is", "has"};

    @Override
    public Class<?> getType() {
        return Object.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        String pathPart;
        ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            Object attributeValue = this.extractBeanPropertyValue(pValue, pathPart, faultHandler);
            return pConverter.extractObject(attributeValue, pPathParts, jsonify);
        }
        if (jsonify) {
            return this.exctractJsonifiedValue(pConverter, pValue, pPathParts);
        }
        return pValue;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Object oldValue;
        String rest = pAttribute.substring(0, 1).toUpperCase() + pAttribute.substring(1);
        String setter = "set" + rest;
        String getter = "get" + rest;
        Class<?> clazz = pInner.getClass();
        Method found = null;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(setter)) continue;
            found = method;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("No Method " + setter + " known for object of type " + clazz.getName());
        }
        Class<?>[] params = found.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("Invalid parameter signature for " + setter + " known for object of type " + clazz.getName() + ". Setter must take exactly one parameter.");
        }
        try {
            Method getMethod = clazz.getMethod(getter, new Class[0]);
            AccessController.doPrivileged(new SetMethodAccessibleAction(getMethod));
            oldValue = getMethod.invoke(pInner, new Object[0]);
        }
        catch (NoSuchMethodException exp) {
            oldValue = null;
        }
        AccessController.doPrivileged(new SetMethodAccessibleAction(found));
        found.invoke(pInner, pConverter.deserialize(params[0].getName(), pValue));
        return oldValue;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    private Object exctractJsonifiedValue(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts) throws AttributeNotFoundException {
        Class<?> pClazz = pValue.getClass();
        if (pClazz.isPrimitive() || FINAL_CLASSES.contains(pClazz) || pClazz == BigDecimal.class || pClazz == BigInteger.class) {
            if (pClazz.equals(Long.class) && "string".equals(pConverter.getSerializeLong())) {
                return pValue.toString();
            }
            return pValue;
        }
        List<String> attributes = this.extractBeanAttributes(pValue);
        if (!attributes.isEmpty()) {
            return this.extractBeanValues(pConverter, pValue, pPathParts, attributes);
        }
        return pValue.toString();
    }

    private Object extractBeanValues(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, List<String> pAttributes) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (String attribute : pAttributes) {
            LinkedList<String> path = new LinkedList<String>(pPathParts);
            try {
                ret.put(attribute, this.extractJsonifiedPropertyValue(pConverter, pValue, attribute, path));
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {}
        }
        if (ret.isEmpty() && !pAttributes.isEmpty()) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractJsonifiedPropertyValue(ObjectToJsonConverter pConverter, Object pValue, String pAttribute, Deque<String> pPathParts) throws AttributeNotFoundException {
        ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
        Object value = this.extractBeanPropertyValue(pValue, pAttribute, faultHandler);
        if (value == null) {
            if (!pPathParts.isEmpty()) {
                faultHandler.handleException((Throwable)new AttributeNotFoundException("Cannot apply remaining path " + EscapeUtil.combineToPath(pPathParts) + " on value null"));
            }
            return null;
        }
        if (value == pValue) {
            if (!pPathParts.isEmpty()) {
                faultHandler.handleException((Throwable)new AttributeNotFoundException("Cannot apply remaining path " + EscapeUtil.combineToPath(pPathParts) + " on a cycle"));
            }
            return "[this]";
        }
        return pConverter.extractObject(value, pPathParts, true);
    }

    private List<String> extractBeanAttributes(Object pValue) {
        ArrayList<String> attrs = new ArrayList<String>();
        for (Method method : pValue.getClass().getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || IGNORE_METHODS.contains(method.getName()) || this.isIgnoredType(method.getReturnType()) || this.hasAnnotation(method, "java.beans.Transient")) continue;
            this.addAttributes(attrs, method);
        }
        return attrs;
    }

    private boolean hasAnnotation(Method method, String annotation) {
        for (Annotation anno : method.getAnnotations()) {
            if (!anno.annotationType().getName().equals(annotation)) continue;
            return true;
        }
        return false;
    }

    private void addAttributes(List<String> pAttrs, Method pMethod) {
        String name = pMethod.getName();
        for (String pref : GETTER_PREFIX) {
            int len;
            String firstLetter;
            if (!name.startsWith(pref) || name.length() <= pref.length() || pMethod.getParameterTypes().length != 0 || !(firstLetter = name.substring(len = pref.length(), len + 1)).toUpperCase().equals(firstLetter)) continue;
            String attribute = new StringBuffer(firstLetter.toLowerCase()).append(name.substring(len + 1)).toString();
            pAttrs.add(attribute);
        }
    }

    private Object extractBeanPropertyValue(Object pValue, String pAttribute, ValueFaultHandler pFaultHandler) throws AttributeNotFoundException {
        Class<?> clazz = pValue.getClass();
        Method method = null;
        String suffix = pAttribute.substring(0, 1).toUpperCase() + pAttribute.substring(1);
        for (String pref : GETTER_PREFIX) {
            try {
                String methodName = pref + suffix;
                method = clazz.getMethod(methodName, new Class[0]);
                break;
            }
            catch (NoSuchMethodException e) {
            }
        }
        if (method == null) {
            try {
                method = clazz.getMethod(pAttribute.substring(0, 1).toLowerCase() + pAttribute.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException exp) {
                method = null;
            }
        }
        if (method == null) {
            return pFaultHandler.handleException((Throwable)new AttributeNotFoundException("No getter known for attribute " + pAttribute + " for class " + pValue.getClass().getName()));
        }
        try {
            method.setAccessible(true);
            return method.invoke(pValue, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return pFaultHandler.handleException((Throwable)new IllegalStateException("Error while extracting " + pAttribute + " from " + pValue, e));
        }
    }

    private boolean isIgnoredType(Class<?> pReturnType) {
        for (Class type : IGNORED_RETURN_TYPES) {
            if (!type.isAssignableFrom(pReturnType)) continue;
            return true;
        }
        return false;
    }

    private static class SetMethodAccessibleAction
    implements PrivilegedAction<Void> {
        private final Method getMethod;

        public SetMethodAccessibleAction(Method pMethod) {
            this.getMethod = pMethod;
        }

        @Override
        public Void run() {
            this.getMethod.setAccessible(true);
            return null;
        }
    }
}

