/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.server.core.service.serializer.SerializeOptions;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.LocalServiceFactory;
import org.jolokia.service.serializer.json.ArrayExtractor;
import org.jolokia.service.serializer.json.BeanExtractor;
import org.jolokia.service.serializer.json.CollectionExtractor;
import org.jolokia.service.serializer.json.CompositeDataExtractor;
import org.jolokia.service.serializer.json.DateExtractor;
import org.jolokia.service.serializer.json.EnumExtractor;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ListExtractor;
import org.jolokia.service.serializer.json.MapExtractor;
import org.jolokia.service.serializer.json.ObjectSerializationContext;
import org.jolokia.service.serializer.json.TabularDataExtractor;
import org.jolokia.service.serializer.object.StringToObjectConverter;

public final class ObjectToJsonConverter {
    private final List<Extractor> handlers;
    private final ArrayExtractor arrayExtractor;
    private final ThreadLocal<ObjectSerializationContext> stackContextLocal = new ThreadLocal();
    private final StringToObjectConverter stringToObjectConverter;
    private static final String SIMPLIFIERS_DEFAULT_DEF = "META-INF/jolokia/simplifiers-default";
    private static final String SIMPLIFIERS_DEF = "META-INF/jolokia/simplifiers";

    public ObjectToJsonConverter(StringToObjectConverter pStringToObjectConverter) {
        this.handlers = new ArrayList<Extractor>();
        this.handlers.add(new TabularDataExtractor());
        this.handlers.add(new CompositeDataExtractor());
        this.handlers.add(new ListExtractor());
        this.handlers.add(new MapExtractor());
        this.handlers.add(new CollectionExtractor());
        this.addSimplifiers(this.handlers);
        this.handlers.add(new EnumExtractor());
        this.handlers.add(new DateExtractor());
        this.handlers.add(new BeanExtractor());
        this.arrayExtractor = new ArrayExtractor();
        this.stringToObjectConverter = pStringToObjectConverter;
    }

    public Object serialize(Object pValue, List<String> pPathParts, SerializeOptions pOptions) throws AttributeNotFoundException {
        Stack extraStack = pPathParts != null ? EscapeUtil.reversePath(pPathParts) : new Stack();
        return this.extractObjectWithContext(pValue, extraStack, pOptions, true);
    }

    public Object setInnerValue(Object pOuterObject, Object pNewValue, List<String> pPathParts) throws AttributeNotFoundException, IllegalAccessException, InvocationTargetException {
        String lastPathElement = pPathParts.remove(pPathParts.size() - 1);
        Stack extraStack = EscapeUtil.reversePath(pPathParts);
        Object inner = this.extractObjectWithContext(pOuterObject, extraStack, SerializeOptions.DEFAULT, false);
        return this.setObjectValue(inner, lastPathElement, pNewValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractObject(Object pValue, Stack<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        Stack<String> pathStack;
        ObjectSerializationContext stackContext = this.stackContextLocal.get();
        String limitReached = this.checkForLimits(pValue, stackContext);
        Stack<String> stack = pathStack = pPathParts != null ? pPathParts : new Stack<String>();
        if (limitReached != null) {
            return limitReached;
        }
        try {
            stackContext.push(pValue);
            if (pValue == null) {
                Object object = pathStack.isEmpty() ? null : stackContext.getValueFaultHandler().handleException((Throwable)new AttributeNotFoundException("Cannot apply a path to an null value"));
                return object;
            }
            if (pValue.getClass().isArray()) {
                Object object = this.arrayExtractor.extractObject(this, pValue, pathStack, pJsonify);
                return object;
            }
            Object object = this.callHandler(pValue, pathStack, pJsonify);
            return object;
        }
        finally {
            stackContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object extractObjectWithContext(Object pValue, Stack<String> pExtraArgs, SerializeOptions pOpts, boolean pJsonify) throws AttributeNotFoundException {
        Object jsonResult;
        this.setupContext(pOpts);
        try {
            jsonResult = this.extractObject(pValue, pExtraArgs, pJsonify);
        }
        catch (ValueFaultHandler.AttributeFilteredException exp) {
            jsonResult = null;
        }
        finally {
            this.clearContext();
        }
        return jsonResult;
    }

    private Object setObjectValue(Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = pInner.getClass();
        if (clazz.isArray()) {
            return this.arrayExtractor.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        Extractor handler = this.getExtractor(clazz);
        if (handler != null) {
            return handler.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + clazz + " for setting object value. (object: " + pInner + ", attribute: " + pAttribute + ", value: " + pValue + ")");
    }

    int getCollectionLength(int originalLength) {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getCollectionSizeTruncated(originalLength);
    }

    public ValueFaultHandler getValueFaultHandler() {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getValueFaultHandler();
    }

    void clearContext() {
        this.stackContextLocal.remove();
    }

    void setupContext() {
        this.setupContext(new SerializeOptions.Builder().build());
    }

    void setupContext(SerializeOptions pOpts) {
        ObjectSerializationContext stackContext = new ObjectSerializationContext(pOpts);
        this.stackContextLocal.set(stackContext);
    }

    private Extractor getExtractor(Class<?> pClazz) {
        for (Extractor handler : this.handlers) {
            if (!handler.canSetValue() || handler.getType() == null || !handler.getType().isAssignableFrom(pClazz)) continue;
            return handler;
        }
        return null;
    }

    private String checkForLimits(Object pValue, ObjectSerializationContext pStackContext) {
        if (pValue != null) {
            if (pStackContext.maxDepthReached()) {
                return pValue.toString();
            }
            if (pStackContext.alreadyVisited(pValue)) {
                return "[Reference " + pValue.getClass().getName() + "@" + Integer.toHexString(pValue.hashCode()) + "]";
            }
        }
        if (pStackContext.maxObjectsExceeded()) {
            return "[Object limit exceeded]";
        }
        return null;
    }

    private Object callHandler(Object pValue, Stack<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        Class<?> pClazz = pValue.getClass();
        for (Extractor handler : this.handlers) {
            if (handler.getType() == null || !handler.getType().isAssignableFrom(pClazz)) continue;
            return handler.extractObject(this, pValue, pPathParts, pJsonify);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + pClazz + " (object: " + pValue + ", extraArgs: " + pPathParts + ")");
    }

    ThreadLocal<ObjectSerializationContext> getStackContextLocal() {
        return this.stackContextLocal;
    }

    private void addSimplifiers(List<Extractor> pHandlers) {
        pHandlers.addAll(LocalServiceFactory.createServices((ClassLoader)this.getClass().getClassLoader(), (String[])new String[]{SIMPLIFIERS_DEFAULT_DEF, SIMPLIFIERS_DEF}));
    }
}

