/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.notif.pull;

import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import org.jolokia.server.core.service.notification.NotificationResult;
import org.jolokia.server.core.service.notification.NotificationSubscription;
import org.jolokia.service.notif.pull.ClientStore;
import org.jolokia.service.notif.pull.PullNotificationStoreMBean;

public class PullNotificationStore
implements PullNotificationStoreMBean {
    private final Map<String, ClientStore> store = new HashMap<String, ClientStore>();
    private final int maxEntries;

    PullNotificationStore(int pMaxEntries) {
        this.maxEntries = pMaxEntries;
    }

    @Override
    public NotificationResult pull(String pClientId, String pHandle) {
        ClientStore clientStore = this.store.get(pClientId);
        if (clientStore != null) {
            return clientStore.pull(pHandle);
        }
        return null;
    }

    void add(NotificationSubscription pRegistration, Notification pNotification) {
        String key = pRegistration.getClient().getId();
        ClientStore clientStore = this.store.computeIfAbsent(key, k -> new ClientStore(this.maxEntries));
        clientStore.add(pRegistration, pNotification);
    }

    void removeSubscription(String pClientId, String pHandle) {
        ClientStore clientStore = this.store.get(pClientId);
        if (clientStore != null) {
            clientStore.removeSubscription(pHandle);
        }
    }

    void removeClient(String pClientId) {
        this.store.remove(pClientId);
    }
}

