/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.service.jmx.api.CacheKeyProvider;
import org.jolokia.service.jmx.handler.list.AttributeDataUpdater;
import org.jolokia.service.jmx.handler.list.ClassNameDataUpdater;
import org.jolokia.service.jmx.handler.list.ConstructorDataUpdater;
import org.jolokia.service.jmx.handler.list.DataKeys;
import org.jolokia.service.jmx.handler.list.DescriptionDataUpdater;
import org.jolokia.service.jmx.handler.list.ListKeysDataUpdater;
import org.jolokia.service.jmx.handler.list.NotificationDataUpdater;
import org.jolokia.service.jmx.handler.list.OperationDataUpdater;

public class MBeanInfoData {
    private final int maxDepth;
    private final Deque<String> pathStack;
    private final ObjectName pathObjectName;
    private final String selectedUpdater;
    private int retrieveAtDepth = 0;
    private final Map<String, Object> infoMap = new JSONObject();
    private static final Map<String, DataUpdater> UPDATERS = new HashMap<String, DataUpdater>();
    private static final DataUpdater LIST_KEYS_UPDATER = new ListKeysDataUpdater();
    private final boolean useCanonicalName;
    private final boolean listKeys;
    private boolean listCache;
    private final String pProvider;

    public MBeanInfoData(int pMaxDepth, Deque<String> pPathStack, boolean pUseCanonicalName, boolean pListKeys, boolean pListCache, String pProvider) {
        this.maxDepth = pMaxDepth;
        this.useCanonicalName = pUseCanonicalName;
        this.listKeys = pListKeys;
        this.listCache = pListCache;
        this.pathStack = pPathStack != null ? new LinkedList<String>(pPathStack) : new LinkedList();
        this.pProvider = pProvider;
        try {
            if (this.pathStack.isEmpty()) {
                this.pathObjectName = null;
            } else {
                String domain = this.pathStack.pop();
                if (domain == null) {
                    domain = "*";
                }
                domain = this.removeProviderIfNeeded(domain);
                String name = "*";
                if (!this.pathStack.isEmpty() && (name = this.pathStack.pop()) == null) {
                    name = "*";
                }
                ObjectName objectName = this.pathObjectName = "*".equals(domain) && "*".equals(name) ? null : new ObjectName(domain + ":" + name);
                if (this.pathObjectName != null && !this.pathObjectName.isDomainPattern()) {
                    ++this.retrieveAtDepth;
                    if (!this.pathObjectName.isPropertyListPattern() && !this.pathObjectName.isPropertyValuePattern()) {
                        ++this.retrieveAtDepth;
                    }
                }
            }
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (this.pathObjectName != null && !this.pathObjectName.isPattern()) {
            this.listCache = false;
        }
        if (this.pathStack.isEmpty()) {
            this.selectedUpdater = null;
        } else {
            this.selectedUpdater = this.pathStack.pop();
            if (this.pathObjectName != null && !this.pathObjectName.isPattern()) {
                ++this.retrieveAtDepth;
            }
        }
        if (!this.pathStack.isEmpty()) {
            throw new IllegalArgumentException("List operation supports only 3 path segments for MBean domain,canonical list of ObjectName properties and updater to use. Remaining path: " + String.join((CharSequence)", ", this.pathStack));
        }
    }

    public boolean handleFirstOrSecondLevel(ObjectName pName) {
        if (this.maxDepth > 2) {
            return false;
        }
        if (this.maxDepth == 1) {
            if (this.pathObjectName == null || this.pathObjectName.apply(pName)) {
                this.infoMap.put(this.addProviderIfNeeded(pName.getDomain()), 1);
            }
            return true;
        }
        if (this.maxDepth == 2) {
            if (this.pathObjectName == null || this.pathObjectName.apply(pName)) {
                Map<String, Object> domain = this.getOrCreateJSONObject(this.infoMap, this.addProviderIfNeeded(pName.getDomain()));
                domain.put(this.getKeyPropertyString(pName), 1);
            }
            return true;
        }
        return false;
    }

    private String getKeyPropertyString(ObjectName pName) {
        return this.useCanonicalName ? pName.getCanonicalKeyPropertyListString() : pName.getKeyPropertyListString();
    }

    public void addMBeanInfo(MBeanServerConnection pConn, ObjectInstance pInstance, Set<DataUpdater> customUpdaters, Set<CacheKeyProvider> cacheKeyProviders) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        Map<String, Object> domain;
        if (this.pathObjectName != null && !this.pathObjectName.apply(pInstance.getObjectName())) {
            return;
        }
        ObjectName objectName = pInstance.getObjectName();
        MBeanInfo mBeanInfo = pConn.getMBeanInfo(objectName);
        String domainName = this.addProviderIfNeeded(objectName.getDomain());
        String mbeanKeyListing = this.getKeyPropertyString(objectName);
        Map<String, Object> mbean = null;
        if (this.listCache) {
            Map<String, Object> domains = this.getOrCreateJSONObject(this.infoMap, "domains");
            domain = this.getOrCreateJSONObject(domains, domainName);
        } else {
            domain = this.getOrCreateJSONObject(this.infoMap, domainName);
            mbean = this.getOrCreateJSONObject(domain, mbeanKeyListing);
        }
        if (!this.listCache) {
            this.addFullMBeanInfo(mbean, objectName, mBeanInfo, objectName, customUpdaters);
        } else {
            CacheKeyProvider provider;
            String key = null;
            Iterator<CacheKeyProvider> iterator = cacheKeyProviders.iterator();
            while (iterator.hasNext() && (key = (provider = iterator.next()).determineKey(pInstance)) == null) {
            }
            Map<String, Object> cache = this.getOrCreateJSONObject(this.infoMap, "cache");
            if (key != null) {
                domain.put(mbeanKeyListing, key);
                mbean = this.getOrCreateJSONObject(cache, key);
                if (mbean.isEmpty()) {
                    this.addFullMBeanInfo(mbean, objectName, mBeanInfo, objectName, customUpdaters);
                }
            } else {
                mbean = this.getOrCreateJSONObject(domain, mbeanKeyListing);
                this.addFullMBeanInfo(mbean, objectName, mBeanInfo, objectName, customUpdaters);
            }
        }
        if (mbean != null && mbean.isEmpty()) {
            domain.remove(mbeanKeyListing);
            if (domain.isEmpty()) {
                this.infoMap.remove(domainName);
            }
        }
    }

    private String addProviderIfNeeded(String pDomain) {
        return this.pProvider != null ? this.pProvider + "@" + pDomain : pDomain;
    }

    private String removeProviderIfNeeded(String pDomain) {
        return this.pProvider != null && pDomain.startsWith(this.pProvider) ? pDomain.substring(this.pProvider.length() + 1) : pDomain;
    }

    public void handleException(ObjectName pName, IOException pExp) throws IOException {
        if (this.retrieveAtDepth != 0) {
            throw new IOException("IOException for MBean " + String.valueOf(pName) + " (" + pExp.getMessage() + ")", pExp);
        }
        this.addException(pName, pExp);
    }

    public void handleException(ObjectName pName, IllegalStateException pExp) {
        if (this.retrieveAtDepth != 0) {
            throw new IllegalStateException("IllegalStateException for MBean " + String.valueOf(pName) + " (" + pExp.getMessage() + ")", pExp);
        }
        this.addException(pName, pExp);
    }

    public void handleException(ObjectName pName, InstanceNotFoundException pExp) throws InstanceNotFoundException {
        if (this.retrieveAtDepth != 0) {
            throw new InstanceNotFoundException("InstanceNotFoundException for MBean " + String.valueOf(pName) + " (" + pExp.getMessage() + ")");
        }
        this.addException(pName, pExp);
    }

    private void addException(ObjectName pName, Exception pExp) {
        Map<String, Object> domain = this.getOrCreateJSONObject(this.infoMap, this.addProviderIfNeeded(pName.getDomain()));
        Map<String, Object> mbean = this.getOrCreateJSONObject(domain, this.getKeyPropertyString(pName));
        mbean.put(DataKeys.ERROR.getKey(), pExp.toString());
    }

    public Object applyPath() {
        Object value = this.navigatePath();
        if (this.maxDepth == 0) {
            return value;
        }
        if (!(value instanceof JSONObject)) {
            return value;
        }
        return this.truncateJSONObject((JSONObject)value, this.maxDepth);
    }

    private void addFullMBeanInfo(Map<String, Object> pMBeanMap, ObjectName pObjectName, MBeanInfo pMBeanInfo, ObjectName pName, Set<DataUpdater> customUpdaters) {
        boolean updaterFound = false;
        for (DataUpdater updater : UPDATERS.values()) {
            if (this.selectedUpdater != null && !updater.getKey().equals(this.selectedUpdater)) continue;
            updater.update(pMBeanMap, pObjectName, pMBeanInfo, null);
            updaterFound = true;
        }
        if (this.listKeys && (this.selectedUpdater == null || LIST_KEYS_UPDATER.getKey().equals(this.selectedUpdater))) {
            LIST_KEYS_UPDATER.update(pMBeanMap, pObjectName, pMBeanInfo, null);
            updaterFound = true;
        }
        for (DataUpdater customUpdater : customUpdaters) {
            if (this.selectedUpdater != null && !customUpdater.getKey().equals(this.selectedUpdater)) continue;
            customUpdater.update(pMBeanMap, pObjectName, pMBeanInfo, null);
            updaterFound = true;
        }
        if (!updaterFound) {
            throw new IllegalArgumentException("Illegal path element for updater selection: " + this.selectedUpdater);
        }
    }

    private Map<String, Object> getOrCreateJSONObject(Map<String, Object> pMap, String pKey) {
        JSONObject nMap = (JSONObject)pMap.get(pKey);
        if (nMap == null) {
            nMap = new JSONObject();
            pMap.put(pKey, nMap);
        }
        return nMap;
    }

    private Object truncateJSONObject(JSONObject pValue, int pMaxDepth) {
        if (pMaxDepth == 0) {
            return 1;
        }
        JSONObject ret = new JSONObject();
        Set entries = pValue.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                ret.put((Object)key, this.truncateJSONObject((JSONObject)value, pMaxDepth - 1));
                continue;
            }
            ret.put((Object)key, value);
        }
        return ret;
    }

    private Object navigatePath() {
        JSONObject innerMap = this.infoMap;
        if (!this.listCache) {
            for (int size = this.retrieveAtDepth; size > 0; --size) {
                Collection<Object> vals = innerMap.values();
                if (vals.isEmpty()) {
                    return innerMap;
                }
                if (vals.size() != 1) {
                    throw new IllegalStateException("Internal: More than one key found when extracting with path: " + String.valueOf(vals));
                }
                Object value = vals.iterator().next();
                if (size == 1) {
                    return value;
                }
                if (!(value instanceof JSONObject)) {
                    throw new IllegalStateException("Internal: Value within path extraction must be a Map, not " + String.valueOf(value.getClass()));
                }
                innerMap = (JSONObject)value;
            }
        }
        return innerMap;
    }

    static {
        for (DataUpdater updater : new DataUpdater[]{new DescriptionDataUpdater(), new ClassNameDataUpdater(), new ConstructorDataUpdater(), new AttributeDataUpdater(), new OperationDataUpdater(), new NotificationDataUpdater()}) {
            UPDATERS.put(updater.getKey(), updater);
        }
    }
}

