/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.misc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.service.container.ContainerLocator;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.jee.AbstractServerDetector;

public class ArtemisDetector
extends AbstractServerDetector {
    private static final String jmxBuilderClass = "org.apache.activemq.artemis.core.server.management.ArtemisRbacMBeanServerBuilder";
    private static final String jmxHandlerClass = "org.apache.activemq.artemis.core.server.management.ArtemisRbacInvocationHandler";
    private static final String artemisBrokerClass = "org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl";
    private static final int ARTEMIS_DETECT_TIMEOUT = 120000;
    private static final int ARTEMIS_DETECT_INTERVAL = 200;
    private static final int ARTEMIS_DETECT_FINAL_DELAY = 200;
    private String artemisVersion = null;
    private Object artemisInstance = null;
    private volatile boolean jvmAgentInitialization = false;

    public ArtemisDetector(int pOrder) {
        super("Artemis", pOrder);
        URL artemisMavenPropertiesLocation = this.getClass().getClassLoader().getResource("META-INF/maven/org.apache.activemq/artemis-boot/pom.properties");
        if (artemisMavenPropertiesLocation != null) {
            try (InputStream is = artemisMavenPropertiesLocation.openStream();){
                Properties props = new Properties();
                props.load(is);
                this.artemisVersion = props.getProperty("version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected int getDetectionTimeout() {
        return 120000;
    }

    @Override
    protected int getDetectionInterval() {
        return 200;
    }

    @Override
    protected int getDetectionFinalDelay() {
        return 200;
    }

    @Override
    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        return this.artemisVersion != null ? new DefaultServerHandle("Apache", this.getName(), this.artemisVersion) : null;
    }

    @Override
    public ClassLoader jvmAgentStartup(Instrumentation instrumentation) {
        if (this.artemisVersion == null) {
            return null;
        }
        boolean artemisBuilderUsed = jmxBuilderClass.equals(System.getProperty("javax.management.builder.initial"));
        AtomicBoolean brokerClassLoaded = new AtomicBoolean(false);
        AtomicBoolean brokerAvailable = new AtomicBoolean(false);
        AtomicBoolean brokerDetectionPossible = new AtomicBoolean(true);
        AtomicReference classloader = new AtomicReference();
        this.activeWait(instrumentation, () -> {
            block9: {
                Class<?> c;
                boolean loaded = brokerClassLoaded.get();
                if (!loaded && (c = this.getClassLoaded(artemisBrokerClass, instrumentation)) != null) {
                    loaded = true;
                    brokerClassLoaded.set(true);
                    classloader.set(c.getClassLoader());
                }
                if (loaded && brokerDetectionPossible.get() && !brokerAvailable.get()) {
                    try {
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        if (!Proxy.isProxyClass(server.getClass())) {
                            brokerDetectionPossible.set(false);
                            break block9;
                        }
                        InvocationHandler handler = Proxy.getInvocationHandler(server);
                        if (!jmxHandlerClass.equals(handler.getClass().getName())) {
                            brokerDetectionPossible.set(false);
                            break block9;
                        }
                        try {
                            Field serverField = handler.getClass().getDeclaredField("activeMQServer");
                            serverField.setAccessible(true);
                            Object brokerInstance = serverField.get(handler);
                            if (brokerInstance != null) {
                                this.artemisInstance = brokerInstance;
                                System.out.println("Jolokia: Detected Artemis broker instance " + brokerInstance.getClass().getName());
                                brokerAvailable.set(true);
                            }
                        }
                        catch (NoSuchFieldException | SecurityException e) {
                            brokerDetectionPossible.set(false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return brokerClassLoaded.get() && (brokerAvailable.get() || !brokerDetectionPossible.get());
        }, "Detected Artemis environment, but broker instance is not discovered after %d seconds");
        this.jvmAgentInitialization = true;
        return (ClassLoader)classloader.get();
    }

    @Override
    public ContainerLocator getContainerLocator(LogHandler logHandler) {
        if (this.jvmAgentInitialization) {
            return this.artemisInstance == null ? null : new ArtemisLocator();
        }
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            if (!Proxy.isProxyClass(server.getClass())) {
                return null;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(server);
            if (!jmxHandlerClass.equals(handler.getClass().getName())) {
                return null;
            }
            try {
                Field serverField = handler.getClass().getDeclaredField("activeMQServer");
                serverField.setAccessible(true);
                Object brokerInstance = serverField.get(handler);
                if (brokerInstance != null) {
                    this.artemisInstance = brokerInstance;
                    logHandler.info("Jolokia: Detected Artemis broker instance " + brokerInstance.getClass().getName());
                    return new ArtemisLocator();
                }
            }
            catch (NoSuchFieldException | SecurityException exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private class ArtemisLocator
    extends AbstractJolokiaService<ContainerLocator>
    implements ContainerLocator {
        protected ArtemisLocator() {
            super(ContainerLocator.class, 0);
        }

        @Override
        public <T> T container(Class<T> clazz) {
            Object instance = ArtemisDetector.this.artemisInstance;
            if (clazz != null && instance != null && clazz.isAssignableFrom(instance.getClass())) {
                return clazz.cast(instance);
            }
            return null;
        }
    }
}

