/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.object;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.util.ClassUtil;
import org.jolokia.service.serializer.object.ObjectToOpenTypeConverter;
import org.jolokia.service.serializer.object.OpenTypeConverter;

public class TabularDataConverter
extends OpenTypeConverter<TabularType> {
    private static final String TD_KEY_KEY = "key";
    private static final String TD_KEY_VALUE = "value";
    private static final String JOLOKIA_KEY_INDEX_NAMES = "indexNames";
    private static final String JOLOKIA_KEY_VALUES = "values";
    private static final String[] MX_BEAN_MAP_ITEMS = new String[]{"key", "value"};
    private static final String[] MX_BEAN_MAP_INDEX = new String[]{"key"};

    public TabularDataConverter(ObjectToOpenTypeConverter pObjectToOpenTypeConverter) {
        super(pObjectToOpenTypeConverter);
    }

    @Override
    boolean canConvert(OpenType<?> pType) {
        return pType instanceof TabularType;
    }

    @Override
    public Object convert(TabularType pType, Object pValue) {
        Map<String, Object> givenValues = this.toMap(pValue);
        if (TabularDataConverter.isMXBeanMapWithSimpleKeys(pType)) {
            return this.createMXBeanTabularData(pType, givenValues);
        }
        if (this.isFullRepresentation(pType, givenValues)) {
            return this.createTabularDataFromFullRepresentation(pType, givenValues);
        }
        TabularDataSupport tabularData = new TabularDataSupport(pType);
        this.putRowsToTabularData(pType, givenValues, tabularData, pType.getIndexNames().size());
        return tabularData;
    }

    public static TabularType createMXBeanTabularType(OpenType<?> keyType, OpenType<?> valueType) throws OpenDataException {
        OpenType[] types = new OpenType[]{keyType, valueType};
        Class cls = keyType.getClass() == SimpleType.class ? ClassUtil.classForName(keyType.getTypeName(), new ClassLoader[0]) : null;
        StringBuilder sb = new StringBuilder();
        if (cls != null && Comparable.class.isAssignableFrom(cls)) {
            sb.append(SortedMap.class.getName());
        } else {
            sb.append(Map.class.getName());
        }
        sb.append("<");
        sb.append(OpenTypeConverter.getMXBeanTypeName(keyType));
        sb.append(", ");
        sb.append(OpenTypeConverter.getMXBeanTypeName(valueType));
        sb.append(">");
        String typeName = sb.toString();
        CompositeType rowType = new CompositeType(typeName, typeName, MX_BEAN_MAP_ITEMS, MX_BEAN_MAP_ITEMS, types);
        return new TabularType(typeName, typeName, rowType, MX_BEAN_MAP_INDEX);
    }

    public static boolean isMXBeanMapWithSimpleKeys(TabularType pType) {
        List<String> indexNames = pType.getIndexNames();
        if (indexNames.size() != 1 || !indexNames.contains(TD_KEY_KEY)) {
            return false;
        }
        CompositeType rowType = pType.getRowType();
        if (!(rowType.getType(TD_KEY_KEY) instanceof SimpleType)) {
            return false;
        }
        if (rowType.keySet().size() == 2) {
            return rowType.keySet().contains(TD_KEY_KEY) && rowType.keySet().contains(TD_KEY_VALUE);
        }
        return false;
    }

    private TabularData createMXBeanTabularData(TabularType pType, Map<String, Object> pValue) {
        CompositeType rowType = pType.getRowType();
        TabularDataSupport tabularData = new TabularDataSupport(pType);
        for (Map.Entry<String, Object> entry : pValue.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TD_KEY_KEY, this.objectToOpenTypeConverter.convert(rowType.getType(TD_KEY_KEY), (Object)entry.getKey()));
            map.put(TD_KEY_VALUE, this.objectToOpenTypeConverter.convert(rowType.getType(TD_KEY_VALUE), entry.getValue()));
            try {
                CompositeDataSupport compositeData = new CompositeDataSupport(rowType, map);
                tabularData.put(compositeData);
            }
            catch (KeyAlreadyExistsException | OpenDataException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return tabularData;
    }

    private boolean isFullRepresentation(TabularType pType, Map<String, Object> pValue) {
        if (pValue.containsKey(JOLOKIA_KEY_INDEX_NAMES) && pValue.containsKey(JOLOKIA_KEY_VALUES) && pValue.size() == 2) {
            Object indexNamesValue = pValue.get(JOLOKIA_KEY_INDEX_NAMES);
            if (!(indexNamesValue instanceof Collection)) {
                throw new IllegalArgumentException("\"indexNames\" field for TabularData must be a Collection<String>, not " + indexNamesValue.getClass().getName());
            }
            Object values = pValue.get(JOLOKIA_KEY_VALUES);
            if (!(values instanceof Collection)) {
                throw new IllegalArgumentException("\"values\" field for TabularData must be a Collection<?>, not " + values.getClass().getName());
            }
            Collection indexNames = (Collection)indexNamesValue;
            List<String> tabularIndexNames = pType.getIndexNames();
            if (indexNames.size() != tabularIndexNames.size()) {
                throw new IllegalArgumentException("Invalid definition of \"indexNames\" - expected " + tabularIndexNames.size() + " entries, found " + indexNames.size() + " entries");
            }
            for (Object index : indexNames) {
                if (!(index instanceof String)) {
                    throw new IllegalArgumentException("Invalid type of index element - expected String, found " + index.getClass().getName());
                }
                if (tabularIndexNames.contains((String)index)) continue;
                throw new IllegalArgumentException("No index element named \"" + String.valueOf(index) + "\" defined in TabularType " + pType.getTypeName());
            }
            return true;
        }
        return false;
    }

    private TabularData createTabularDataFromFullRepresentation(TabularType pType, Map<String, Object> pValue) {
        Collection jsonVal = (Collection)pValue.get(JOLOKIA_KEY_VALUES);
        TabularDataSupport tabularData = new TabularDataSupport(pType);
        for (Object val : jsonVal) {
            if (!(val instanceof Map)) {
                throw new IllegalArgumentException("TabularData values must be given as Maps or JSONObjects, not " + val.getClass().getName());
            }
            tabularData.put((CompositeData)this.objectToOpenTypeConverter.convert(pType.getRowType(), val));
        }
        return tabularData;
    }

    private void putRowsToTabularData(TabularType pType, Map<String, Object> pValue, TabularDataSupport pTabularData, int pLevel) {
        for (Object value : pValue.values()) {
            if (!(value instanceof JSONObject)) {
                throw new IllegalArgumentException("Cannot convert " + this.trim(pValue.toString()) + " to " + String.valueOf(pType) + " because the object provided (" + value.getClass().getName() + ") is not of the expected type JSONObject at level " + pLevel);
            }
            JSONObject jsonValue = (JSONObject)value;
            if (pLevel > 1) {
                this.putRowsToTabularData(pType, jsonValue, pTabularData, pLevel - 1);
                continue;
            }
            pTabularData.put((CompositeData)this.objectToOpenTypeConverter.convert(pType.getRowType(), (Object)jsonValue));
        }
    }
}

