/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.server.core.util.JsonUtil;
import org.jolokia.service.jmx.handler.list.DataKeys;

public class ConstructorDataUpdater
extends DataUpdater {
    protected ConstructorDataUpdater() {
        super(100);
    }

    @Override
    public String getKey() {
        return DataKeys.CONSTRUCTORS.getKey();
    }

    @Override
    public JSONObject extractData(ObjectName pObjectName, MBeanInfo pMBeanInfo, String pName) {
        JSONObject opMap = new JSONObject();
        for (MBeanConstructorInfo ctorInfo : pMBeanInfo.getConstructors()) {
            if (pName != null && !ctorInfo.getName().equals(pName)) continue;
            JSONObject map = new JSONObject();
            JSONArray argList = new JSONArray(ctorInfo.getSignature().length);
            for (MBeanParameterInfo paramInfo : ctorInfo.getSignature()) {
                JSONObject args = new JSONObject();
                args.put(DataKeys.DESCRIPTION.getKey(), paramInfo.getDescription());
                args.put(DataKeys.NAME.getKey(), paramInfo.getName());
                args.put(DataKeys.TYPE.getKey(), paramInfo.getType());
                argList.add(args);
            }
            map.put(DataKeys.ARGS.getKey(), argList);
            map.put(DataKeys.DESCRIPTION.getKey(), ctorInfo.getDescription());
            JsonUtil.addJSONObjectToJSONObject(opMap, ctorInfo.getName(), map);
        }
        return opMap;
    }
}

