/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.util.Deque;
import java.util.Map;
import java.util.SortedSet;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.api.CacheKeyProvider;
import org.jolokia.service.jmx.handler.list.MBeanInfoData;

class ListMBeanEachAction
implements MBeanServerAccess.MBeanEachCallback,
MBeanServerAccess.MBeanAction<Void> {
    private final MBeanInfoData infoData;
    private final JolokiaContext context;
    private final SortedSet<DataUpdater> customUpdaters;
    private final SortedSet<CacheKeyProvider> cacheKeyProviders;

    public ListMBeanEachAction(int pMaxDepth, Deque<String> pPathStack, boolean pUseCanonicalName, boolean pListKeys, boolean pListCache, String pProvider, JolokiaContext pContext) {
        this.context = pContext;
        this.infoData = new MBeanInfoData(pMaxDepth, pPathStack, pUseCanonicalName, pListKeys, pListCache, pProvider);
        this.customUpdaters = this.context.getServices(DataUpdater.class);
        this.cacheKeyProviders = this.context.getServices(CacheKeyProvider.class);
    }

    @Override
    public void callback(MBeanServerConnection pConn, ObjectInstance pInstance) throws ReflectionException, InstanceNotFoundException, IOException {
        this.lookupMBeanInfo(pConn, pInstance);
    }

    @Override
    public Void execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException {
        this.lookupMBeanInfo(pConn, new ObjectInstance(pName, null));
        return null;
    }

    private void lookupMBeanInfo(MBeanServerConnection pConn, ObjectInstance pInstance) throws InstanceNotFoundException, ReflectionException, IOException {
        ObjectName objectName = pInstance.getObjectName();
        if (this.context.isObjectNameHidden(objectName)) {
            return;
        }
        if (!this.infoData.handleFirstOrSecondLevel(objectName)) {
            try {
                this.infoData.addMBeanInfo(pConn, pInstance, this.customUpdaters, this.cacheKeyProviders);
            }
            catch (IOException exp) {
                this.infoData.handleException(objectName, exp);
            }
            catch (InstanceNotFoundException exp) {
                this.infoData.handleException(objectName, exp);
            }
            catch (IllegalStateException exp) {
                this.infoData.handleException(objectName, exp);
            }
            catch (IntrospectionException exp) {
                throw new IllegalArgumentException("Cannot extra MBeanInfo for " + String.valueOf(objectName) + ": " + String.valueOf(exp), exp);
            }
        }
    }

    public Object getResult(Map pBaseMap) {
        Object result = this.infoData.applyPath();
        if (pBaseMap != null && result instanceof Map) {
            Map resultMap = (Map)result;
            for (Map.Entry entry : resultMap.entrySet()) {
                pBaseMap.put(entry.getKey(), entry.getValue());
            }
            return pBaseMap;
        }
        return result;
    }
}

