/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.misc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.service.container.ContainerLocator;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.jee.AbstractServerDetector;

public class ArtemisDetector
extends AbstractServerDetector {
    private static final String oldJmxBuilderClass = "org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerBuilder";
    private static final String newJmxBuilderClass = "org.apache.activemq.artemis.core.server.management.ArtemisRbacMBeanServerBuilder";
    private static final String oldJmxHandlerClass = "org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerBuilder$MBeanInvocationHandler";
    private static final String newJmxHandlerClass = "org.apache.activemq.artemis.core.server.management.ArtemisRbacInvocationHandler";
    private static final String artemisBrokerClass = "org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl";
    private static final Duration ARTEMIS_DETECT_TIMEOUT = Duration.ofMinutes(2L);
    private static final Duration ARTEMIS_DETECT_INTERVAL = Duration.ofMillis(200L);
    private static final Duration ARTEMIS_DETECT_FINAL_DELAY = Duration.ofMillis(200L);
    private String artemisVersion = null;
    private Object artemisGuardInvocationHandler = null;
    private Object artemisInstance = null;
    private volatile boolean jvmAgentInitialization = false;

    public ArtemisDetector(int pOrder) {
        super("Artemis", pOrder);
        URL artemisVersionPropertiesLocation;
        URL artemisMavenPropertiesLocation = this.getClass().getClassLoader().getResource("META-INF/maven/org.apache.activemq/artemis-boot/pom.properties");
        if (artemisMavenPropertiesLocation != null) {
            try (InputStream is2 = artemisMavenPropertiesLocation.openStream();){
                Properties props = new Properties();
                props.load(is2);
                this.artemisVersion = props.getProperty("version");
                return;
            }
            catch (IOException is2) {
                // empty catch block
            }
        }
        if ((artemisVersionPropertiesLocation = this.getClass().getClassLoader().getResource("activemq-version.properties")) != null) {
            try (InputStream is = artemisVersionPropertiesLocation.openStream();){
                Properties props = new Properties();
                props.load(is);
                this.artemisVersion = props.getProperty("activemq.version.versionName");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected int getDetectionTimeout() {
        return (int)ARTEMIS_DETECT_TIMEOUT.toMillis();
    }

    @Override
    protected int getDetectionInterval() {
        return (int)ARTEMIS_DETECT_INTERVAL.toMillis();
    }

    @Override
    protected int getDetectionFinalDelay() {
        return (int)ARTEMIS_DETECT_FINAL_DELAY.toMillis();
    }

    @Override
    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        return this.artemisVersion != null ? new DefaultServerHandle("Apache", this.getName(), this.artemisVersion) : null;
    }

    @Override
    public ClassLoader jvmAgentStartup(Instrumentation instrumentation) {
        if (this.artemisVersion == null) {
            return null;
        }
        boolean oldArtemisBuilderUsed = oldJmxBuilderClass.equals(System.getProperty("javax.management.builder.initial"));
        boolean newArtemisBuilderUsed = newJmxBuilderClass.equals(System.getProperty("javax.management.builder.initial"));
        AtomicBoolean brokerClassLoaded = new AtomicBoolean(false);
        AtomicBoolean guardAvailable = new AtomicBoolean(false);
        AtomicBoolean guardDetectionPossible = new AtomicBoolean(true);
        AtomicReference classloader = new AtomicReference();
        this.activeWait(instrumentation, () -> {
            block16: {
                Class<?> c;
                boolean loaded = brokerClassLoaded.get();
                if (!loaded && (c = this.getClassLoaded(artemisBrokerClass, instrumentation)) != null) {
                    loaded = true;
                    brokerClassLoaded.set(true);
                    classloader.set(c.getClassLoader());
                }
                if (loaded && guardDetectionPossible.get() && !guardAvailable.get()) {
                    try {
                        String builderClass = System.getProperty("javax.management.builder.initial");
                        if (!oldJmxBuilderClass.equals(builderClass) && !newJmxBuilderClass.equals(builderClass)) {
                            return false;
                        }
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        if (!Proxy.isProxyClass(server.getClass())) {
                            guardDetectionPossible.set(false);
                            break block16;
                        }
                        InvocationHandler handler = Proxy.getInvocationHandler(server);
                        String ihClass = handler.getClass().getName();
                        if (!oldJmxHandlerClass.equals(ihClass) && !newJmxHandlerClass.equals(ihClass)) {
                            guardDetectionPossible.set(false);
                            break block16;
                        }
                        if (oldJmxHandlerClass.equals(ihClass)) {
                            try {
                                Class<?> c2 = handler.getClass().getClassLoader().loadClass(oldJmxBuilderClass);
                                Field guardField = c2.getDeclaredField("guard");
                                guardField.setAccessible(true);
                                Object guard = guardField.get(null);
                                if (guard != null) {
                                    this.artemisGuardInvocationHandler = guard;
                                    guardAvailable.set(true);
                                }
                            }
                            catch (ClassNotFoundException | NoSuchFieldException | SecurityException e) {
                                guardDetectionPossible.set(false);
                            }
                        }
                        if (newJmxHandlerClass.equals(ihClass)) {
                            try {
                                Field serverField = handler.getClass().getDeclaredField("activeMQServer");
                                serverField.setAccessible(true);
                                Object brokerInstance = serverField.get(handler);
                                if (brokerInstance != null) {
                                    this.artemisInstance = brokerInstance;
                                    this.artemisGuardInvocationHandler = handler;
                                    guardAvailable.set(true);
                                }
                            }
                            catch (NoSuchFieldException | SecurityException e) {
                                guardDetectionPossible.set(false);
                            }
                        }
                        if (guardAvailable.get()) {
                            System.out.println("Jolokia: Detected Artemis guard handler " + ihClass);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return brokerClassLoaded.get() && (guardAvailable.get() || !guardDetectionPossible.get());
        }, "Detected Artemis environment, but Broker and MBeanServer guard instances are not discovered after %d seconds");
        this.jvmAgentInitialization = true;
        return (ClassLoader)classloader.get();
    }

    @Override
    public ContainerLocator getContainerLocator(LogHandler logHandler) {
        if (this.jvmAgentInitialization) {
            return this.artemisGuardInvocationHandler == null ? null : new ArtemisLocator();
        }
        ArtemisLocator result = null;
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            if (!Proxy.isProxyClass(server.getClass())) {
                return null;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(server);
            String ihClass = handler.getClass().getName();
            if (!oldJmxHandlerClass.equals(ihClass) && !newJmxHandlerClass.equals(ihClass)) {
                return null;
            }
            if (oldJmxHandlerClass.equals(ihClass)) {
                try {
                    Class<?> c = handler.getClass().getClassLoader().loadClass(oldJmxBuilderClass);
                    Field guardField = c.getDeclaredField("guard");
                    guardField.setAccessible(true);
                    Object guard = guardField.get(null);
                    if (guard != null) {
                        this.artemisGuardInvocationHandler = guard;
                        result = new ArtemisLocator();
                    }
                }
                catch (NoSuchFieldException | SecurityException c) {
                    // empty catch block
                }
            }
            if (newJmxHandlerClass.equals(ihClass)) {
                try {
                    Field serverField = handler.getClass().getDeclaredField("activeMQServer");
                    serverField.setAccessible(true);
                    Object brokerInstance = serverField.get(handler);
                    if (brokerInstance != null) {
                        this.artemisInstance = brokerInstance;
                        this.artemisGuardInvocationHandler = handler;
                        result = new ArtemisLocator();
                    }
                }
                catch (NoSuchFieldException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (result != null) {
                logHandler.info("Jolokia: Detected Artemis guard handler " + ihClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private class ArtemisLocator
    extends AbstractJolokiaService<ContainerLocator>
    implements ContainerLocator {
        protected ArtemisLocator() {
            super(ContainerLocator.class, 0);
        }

        @Override
        public <T> T locate(Class<T> clazz) {
            if (clazz != null) {
                if (ArtemisDetector.this.artemisGuardInvocationHandler != null && clazz.isAssignableFrom(ArtemisDetector.this.artemisGuardInvocationHandler.getClass())) {
                    return clazz.cast(ArtemisDetector.this.artemisGuardInvocationHandler);
                }
                if (ArtemisDetector.this.artemisInstance != null && clazz.isAssignableFrom(ArtemisDetector.this.artemisInstance.getClass())) {
                    return clazz.cast(ArtemisDetector.this.artemisInstance);
                }
            }
            return null;
        }
    }
}

