/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.impl;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.jolokia.json.JSONObject;
import org.jolokia.json.parser.JSONParser;
import org.jolokia.server.core.auth.JolokiaAgentPrincipal;
import org.jolokia.server.core.backend.MBeanServerHandler;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.detector.ServerDetector;
import org.jolokia.server.core.detector.ServerDetectorLookup;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.api.JolokiaServiceCreator;
import org.jolokia.server.core.service.api.JolokiaServiceLookup;
import org.jolokia.server.core.service.api.JolokiaServiceManager;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.service.api.SecurityDetails;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.service.container.ContainerLocator;
import org.jolokia.server.core.service.impl.ClasspathServerDetectorLookup;
import org.jolokia.server.core.service.impl.ConfigRequestHandler;
import org.jolokia.server.core.service.impl.JolokiaContextImpl;
import org.jolokia.server.core.service.impl.MBeanRegistry;
import org.jolokia.server.core.service.impl.VersionRequestHandler;
import org.jolokia.server.core.service.request.RequestHandler;
import org.jolokia.server.core.service.request.RequestInterceptor;
import org.jolokia.server.core.util.DebugStore;
import org.jolokia.server.core.util.jmx.DefaultMBeanServerAccess;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;

public class JolokiaServiceManagerImpl
implements JolokiaServiceManager {
    private AgentDetails agentDetails;
    private SecurityDetails securityDetails;
    private final ServerDetectorLookup detectorLookup;
    private final Configuration configuration;
    private final LogHandler logHandler;
    private final Restrictor restrictor;
    private boolean isInitialized;
    private static final Class<?>[] SERVICE_TYPE_ORDER = new Class[]{ServerDetector.class, RequestHandler.class};
    private final List<JolokiaServiceLookup> serviceLookups;
    private final Map<Class<? extends JolokiaService<?>>, SortedSet<? extends JolokiaService<?>>> staticServices;
    private final Map<Class<? extends JolokiaService<?>>, JolokiaService<?>> staticLowServices;
    private JolokiaContextImpl jolokiaContext;
    private MBeanRegistry mbeanRegistry;
    private DefaultMBeanServerAccess mbeanServerAccess;
    private final DebugStore debugStore;
    private ObjectName mBeanServerHandlerName;
    private Set<String> enabledServices;
    private Set<String> disabledServices;

    public JolokiaServiceManagerImpl(Configuration pConfig, LogHandler pLogHandler, Restrictor pRestrictor, ServerDetectorLookup pDetectorLookup) {
        this.configuration = pConfig;
        this.logHandler = pLogHandler;
        this.restrictor = pRestrictor;
        this.isInitialized = false;
        this.serviceLookups = new ArrayList<JolokiaServiceLookup>();
        this.staticServices = new HashMap();
        this.staticLowServices = new HashMap();
        this.detectorLookup = pDetectorLookup != null ? pDetectorLookup : new ClasspathServerDetectorLookup();
        this.addService(new VersionRequestHandler());
        this.addService(new ConfigRequestHandler());
        this.debugStore = new DebugStore();
        this.addService(this.debugStore);
        this.configureEnabledServices();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    public Restrictor getRestrictor() {
        return this.restrictor;
    }

    @Override
    public final synchronized void addService(JolokiaService<?> pService) {
        Class<?> type = pService.getType();
        SortedSet<JolokiaService<?>> servicesOfType = this.staticServices.get(type);
        if (servicesOfType == null) {
            servicesOfType = new TreeSet();
            this.staticServices.put(type, servicesOfType);
        }
        servicesOfType.add(pService);
        JolokiaService<?> pLowService = this.staticLowServices.get(type);
        if (pLowService == null || pLowService.getOrder() > pService.getOrder()) {
            this.staticLowServices.put(type, pService);
        }
    }

    @Override
    public void addServiceLookup(JolokiaServiceLookup pLookup) {
        this.serviceLookups.add(pLookup);
    }

    @Override
    public void addServices(JolokiaServiceCreator pServiceCreator) {
        for (JolokiaService<?> service : pServiceCreator.getServices(this.logHandler)) {
            this.addService(service);
        }
    }

    @Override
    public synchronized JolokiaContext start() {
        if (!this.isInitialized) {
            ServerHandle handle = Subject.doAs(JolokiaAgentPrincipal.asSubject(), new PrivilegedAction<ServerHandle>(){

                @Override
                public ServerHandle run() {
                    SortedSet<ServerDetector> detectors = new TreeSet<ServerDetector>();
                    if (!Boolean.parseBoolean(JolokiaServiceManagerImpl.this.configuration.getConfig(ConfigKey.DISABLE_DETECTORS))) {
                        detectors = JolokiaServiceManagerImpl.this.detectorLookup.lookup(JolokiaServiceManagerImpl.this.logHandler);
                    }
                    JolokiaServiceManagerImpl.this.mbeanServerAccess = JolokiaServiceManagerImpl.this.createMBeanServerAccess(detectors);
                    return JolokiaServiceManagerImpl.this.detect(JolokiaServiceManagerImpl.this.getDetectorOptions(), detectors, JolokiaServiceManagerImpl.this.mbeanServerAccess);
                }
            });
            this.agentDetails = new AgentDetails(this.configuration, handle);
            this.securityDetails = this.configuration.getSecurityDetails();
            this.jolokiaContext = new JolokiaContextImpl(this);
            this.jolokiaContext.setDebugStore(this.debugStore);
            this.mbeanRegistry = new MBeanRegistry();
            MBeanServerHandler mBeanServerHandler = new MBeanServerHandler(this.mbeanServerAccess);
            try {
                this.mBeanServerHandlerName = new ObjectName("jolokia:type=ServerHandler,agent=" + this.getAgentDetails().getAgentId());
                this.jolokiaContext.registerMBean(mBeanServerHandler, this.mBeanServerHandlerName.toString());
            }
            catch (JMException e) {
                this.jolokiaContext.error("Cannot register MBean " + String.valueOf(this.mBeanServerHandlerName) + ": " + String.valueOf(e), e);
            }
            List<Class<JolokiaService<?>>> serviceTypes = this.getServiceTypes();
            Iterator<Class<JolokiaService<?>>> it1 = serviceTypes.iterator();
            while (it1.hasNext()) {
                Class<? extends JolokiaService<?>> serviceType = it1.next();
                Set services = this.staticServices.get(serviceType);
                if (services == null) continue;
                Iterator it2 = services.iterator();
                while (it2.hasNext()) {
                    JolokiaService service = (JolokiaService)it2.next();
                    if (service.isEnabled(this.jolokiaContext)) {
                        service.init(this.jolokiaContext);
                        continue;
                    }
                    it2.remove();
                }
                if (!services.isEmpty()) continue;
                it1.remove();
            }
            this.staticLowServices.values().removeIf(value -> !this.isServiceEnabled(value.getClass().getName()));
            for (JolokiaServiceLookup lookup : this.serviceLookups) {
                lookup.init(this.jolokiaContext);
            }
            this.isInitialized = true;
        }
        return this.jolokiaContext;
    }

    @Override
    public synchronized void stop() {
        Subject.doAs(JolokiaAgentPrincipal.asSubject(), new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JolokiaServiceManagerImpl.this.stopInternal();
                return null;
            }
        });
    }

    private synchronized void stopInternal() {
        if (this.isInitialized) {
            try {
                this.mbeanRegistry.destroy();
            }
            catch (JMException e) {
                this.logHandler.error("Cannot unregister own MBeans: " + String.valueOf(e), e);
            }
            if (this.mBeanServerHandlerName != null) {
                try {
                    this.jolokiaContext.unregisterMBean(this.mBeanServerHandlerName);
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                    // empty catch block
                }
            }
            for (JolokiaServiceLookup jolokiaServiceLookup : this.serviceLookups) {
                jolokiaServiceLookup.destroy();
            }
            for (Class clazz : this.getServiceTypes()) {
                Set services = this.staticServices.get(clazz);
                if (services == null) continue;
                for (JolokiaService service : services) {
                    try {
                        service.destroy();
                    }
                    catch (Exception e) {
                        this.logHandler.error("Error while stopping service " + String.valueOf(service) + " of type " + String.valueOf(service.getType()) + ": " + String.valueOf(e), e);
                    }
                }
            }
            this.isInitialized = false;
        }
    }

    public <T extends JolokiaService<?>> SortedSet<T> getServices(Class<T> pType) {
        SortedSet<? extends JolokiaService<?>> services = this.staticServices.get(pType);
        TreeSet ret = services != null ? new TreeSet(services) : new TreeSet();
        for (JolokiaServiceLookup factory : this.serviceLookups) {
            ret.addAll(factory.getServices(pType));
        }
        return ret;
    }

    public <T extends JolokiaService<?>> T getService(Class<T> pType) {
        JolokiaService ret = this.staticLowServices.get(pType);
        int order = ret != null ? ret.getOrder() : Integer.MAX_VALUE;
        for (JolokiaServiceLookup factory : this.serviceLookups) {
            for (JolokiaService service : factory.getServices(pType)) {
                if (service.getOrder() >= order) continue;
                ret = service;
                order = ret.getOrder();
            }
        }
        return (T)ret;
    }

    @Override
    public boolean isServiceEnabled(String serviceClassName) {
        if (this.disabledServices != null) {
            return !this.disabledServices.contains(serviceClassName);
        }
        if (this.enabledServices != null) {
            return this.enabledServices.contains(serviceClassName);
        }
        return true;
    }

    MBeanServerAccess getMBeanServerAccess() {
        return this.mbeanServerAccess;
    }

    private ServerHandle detect(Map<String, Object> pConfig, SortedSet<ServerDetector> detectors, MBeanServerAccess pMBeanServerAccess) {
        for (ServerDetector detector : detectors) {
            try {
                detector.init((Map)pConfig.get(detector.getName()));
                ServerHandle info = detector.detect(pMBeanServerAccess);
                if (info == null) continue;
                this.addInterceptor(detector, pMBeanServerAccess);
                this.addRuntimeLocator(detector);
                return info;
            }
            catch (Exception exp) {
                this.logHandler.error("Error while using detector " + detector.getClass().getSimpleName() + ": " + String.valueOf(exp), exp);
            }
        }
        return DefaultServerHandle.NULL_SERVER_HANDLE;
    }

    private void addInterceptor(ServerDetector detector, MBeanServerAccess pServerAccess) {
        RequestInterceptor interceptor = detector.getRequestInterceptor(pServerAccess);
        if (interceptor != null) {
            this.addService(interceptor);
        }
    }

    private void addRuntimeLocator(ServerDetector detector) {
        ContainerLocator locator = detector.getContainerLocator(this.logHandler);
        if (locator != null) {
            this.addService(locator);
        }
    }

    private DefaultMBeanServerAccess createMBeanServerAccess(SortedSet<ServerDetector> pDetectors) {
        HashSet<MBeanServerConnection> mbeanServers = new HashSet<MBeanServerConnection>();
        for (ServerDetector detector : pDetectors) {
            Set<MBeanServerConnection> found = detector.getMBeanServers();
            if (found == null) continue;
            mbeanServers.addAll(found);
        }
        return new DefaultMBeanServerAccess(mbeanServers);
    }

    private Map<String, Object> getDetectorOptions() {
        String optionString = this.configuration.getConfig(ConfigKey.DETECTOR_OPTIONS);
        if (optionString != null) {
            try {
                return new JSONParser().parse(optionString, JSONObject.class);
            }
            catch (Exception e) {
                this.logHandler.error("Could not parse detetctor options '" + optionString + "' as JSON object: " + String.valueOf(e), e);
            }
        } else {
            return Collections.emptyMap();
        }
        return null;
    }

    private List<Class<? extends JolokiaService<?>>> getServiceTypes() {
        ArrayList ret = new ArrayList();
        for (Class<?> type : SERVICE_TYPE_ORDER) {
            ret.add(type);
        }
        for (Class clazz : this.staticServices.keySet()) {
            if (ret.contains(clazz)) continue;
            ret.add(clazz);
        }
        return ret;
    }

    public AgentDetails getAgentDetails() {
        return this.agentDetails;
    }

    public SecurityDetails getSecurityDetails() {
        return this.securityDetails;
    }

    public final ObjectName registerMBean(Object pMBean, String ... pOptionalName) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        return this.mbeanRegistry.registerMBean(pMBean, pOptionalName);
    }

    public final void unregisterMBean(ObjectName pObjectName) throws MBeanRegistrationException {
        this.mbeanRegistry.unregisterMBean(pObjectName);
    }

    private void configureEnabledServices() {
        String enabledServices = this.configuration.getConfig(ConfigKey.ENABLED_SERVICES);
        String disabledServices = this.configuration.getConfig(ConfigKey.DISABLED_SERVICES);
        if (disabledServices != null && !disabledServices.trim().isEmpty()) {
            this.disabledServices = Arrays.stream(disabledServices.split("\\s*,\\s*")).map(String::trim).collect(Collectors.toUnmodifiableSet());
        } else if (enabledServices != null && !enabledServices.trim().isEmpty()) {
            this.enabledServices = Arrays.stream(enabledServices.split("\\s*,\\s*")).map(String::trim).collect(Collectors.toUnmodifiableSet());
        }
    }
}

