/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.misc;

import java.lang.instrument.Instrumentation;
import java.util.Properties;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.jee.AbstractServerDetector;

public class LightstreamerDetector
extends AbstractServerDetector {
    private static final String[] SYSTEM_PROPERTY_NAMES = new String[]{"com.lightstreamer.internal_lib_path", "com.lightstreamer.kernel_lib_path", "com.lightstreamer.logging_lib_path", "com.lightstreamer.database_lib_path"};
    private static final int LIGHTSTREAMER_DETECT_TIMEOUT = 300000;
    private static final int LIGHTSTREAMER_DETECT_INTERVAL = 200;
    private static final int LIGHTSTREAMER_DETECT_FINAL_DELAY = 500;
    private static final String LIGHTSTREAMER_MBEAN_CLASS = "com.lightstreamer.jmx.ServerMBean";

    public LightstreamerDetector(int pOrder) {
        super("lightstreamer", pOrder);
    }

    @Override
    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        String serverVersion = this.getSingleStringAttribute(pMBeanServerAccess, "com.lightstreamer:type=Server", "LSVersion");
        if (serverVersion != null) {
            return new DefaultServerHandle("LightStreamer", "LightStreamer", serverVersion);
        }
        return null;
    }

    @Override
    public ClassLoader jvmAgentStartup(Instrumentation instrumentation) {
        if (this.isLightStreamer(instrumentation)) {
            this.awaitLightstreamerMBeans(instrumentation);
        }
        return null;
    }

    protected boolean isLightStreamer(Instrumentation instrumentation) {
        Properties systemProperties = System.getProperties();
        for (String expectedPropertyName : SYSTEM_PROPERTY_NAMES) {
            if (!systemProperties.containsKey(expectedPropertyName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getDetectionTimeout() {
        return 300000;
    }

    @Override
    protected int getDetectionInterval() {
        return 200;
    }

    @Override
    protected int getDetectionFinalDelay() {
        return 500;
    }

    private void awaitLightstreamerMBeans(Instrumentation instrumentation) {
        this.activeWait(instrumentation, () -> this.isClassLoaded(LIGHTSTREAMER_MBEAN_CLASS, instrumentation), "Detected Lightstreamer, but JMX MBeans were not loaded after %d seconds");
    }
}

