/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.management.AttributeNotFoundException;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.serializer.SerializeOptions;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.LocalServiceFactory;
import org.jolokia.service.serializer.json.ArrayExtractor;
import org.jolokia.service.serializer.json.BeanExtractor;
import org.jolokia.service.serializer.json.CalendarExtractor;
import org.jolokia.service.serializer.json.CollectionExtractor;
import org.jolokia.service.serializer.json.CompositeDataExtractor;
import org.jolokia.service.serializer.json.DateExtractor;
import org.jolokia.service.serializer.json.EnumExtractor;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ListExtractor;
import org.jolokia.service.serializer.json.MapExtractor;
import org.jolokia.service.serializer.json.ObjectSerializationContext;
import org.jolokia.service.serializer.json.TabularDataExtractor;
import org.jolokia.service.serializer.json.TemporalExtractor;
import org.jolokia.service.serializer.object.StringToObjectConverter;

public final class ObjectToJsonConverter {
    private final List<Extractor> handlers;
    private final ArrayExtractor arrayExtractor;
    private final ThreadLocal<ObjectSerializationContext> stackContextLocal = new ThreadLocal();
    private final StringToObjectConverter stringToObjectConverter;
    private static final String SIMPLIFIERS_DEFAULT_DEF = "META-INF/jolokia/simplifiers-default";
    private static final String SIMPLIFIERS_DEF = "META-INF/jolokia/simplifiers";
    private final JolokiaContext context;

    public ObjectToJsonConverter(StringToObjectConverter pStringToObjectConverter) {
        this(pStringToObjectConverter, null);
    }

    public ObjectToJsonConverter(StringToObjectConverter pStringToObjectConverter, JolokiaContext context) {
        this.handlers = new ArrayList<Extractor>();
        this.handlers.add(new TabularDataExtractor());
        this.handlers.add(new CompositeDataExtractor());
        this.handlers.add(new ListExtractor());
        this.handlers.add(new MapExtractor());
        this.handlers.add(new CollectionExtractor());
        this.addSimplifiers(this.handlers);
        this.handlers.add(new EnumExtractor());
        String dateFormat = context == null ? ConfigKey.DATE_FORMAT.getDefaultValue() : context.getConfig(ConfigKey.DATE_FORMAT);
        TimeZone dateFormatZone = context == null ? TimeZone.getDefault() : TimeZone.getTimeZone(context.getConfig(ConfigKey.DATE_FORMAT_ZONE));
        this.handlers.add(new DateExtractor(dateFormat, dateFormatZone));
        this.handlers.add(new CalendarExtractor(dateFormat, dateFormatZone));
        this.handlers.add(new TemporalExtractor(dateFormat, dateFormatZone));
        this.handlers.add(new BeanExtractor());
        this.arrayExtractor = new ArrayExtractor();
        this.stringToObjectConverter = pStringToObjectConverter;
        this.context = context;
    }

    public Object serialize(Object pValue, List<String> pPathParts, SerializeOptions pOptions) throws AttributeNotFoundException {
        LinkedList<String> extraStack = pPathParts != null ? EscapeUtil.reversePath(pPathParts) : new LinkedList<String>();
        return this.extractObjectWithContext(pValue, extraStack, pOptions, true);
    }

    public Object setInnerValue(Object pOuterObject, Object pNewValue, List<String> pPathParts) throws AttributeNotFoundException, IllegalAccessException, InvocationTargetException {
        String lastPathElement = pPathParts.remove(pPathParts.size() - 1);
        Deque<String> extraStack = EscapeUtil.reversePath(pPathParts);
        Object inner = this.extractObjectWithContext(pOuterObject, extraStack, SerializeOptions.DEFAULT, false);
        return this.setObjectValue(inner, lastPathElement, pNewValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractObject(Object pValue, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        LinkedList<String> pathStack;
        ObjectSerializationContext stackContext = this.stackContextLocal.get();
        String limitReached = this.checkForLimits(pValue, stackContext);
        LinkedList<String> linkedList = pathStack = pPathParts != null ? pPathParts : new LinkedList<String>();
        if (limitReached != null) {
            return limitReached;
        }
        try {
            stackContext.push(pValue);
            if (pValue == null) {
                Object object = pathStack.isEmpty() ? null : stackContext.getValueFaultHandler().handleException(new AttributeNotFoundException("Cannot apply a path to an null value"));
                return object;
            }
            if (pValue.getClass().isArray()) {
                Object object = this.arrayExtractor.extractObject(this, pValue, pathStack, pJsonify);
                return object;
            }
            Object object = this.callHandler(pValue, pathStack, pJsonify);
            return object;
        }
        finally {
            stackContext.pop(pValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object extractObjectWithContext(Object pValue, Deque<String> pExtraArgs, SerializeOptions pOpts, boolean pJsonify) throws AttributeNotFoundException {
        Object jsonResult;
        this.setupContext(pOpts);
        try {
            jsonResult = this.extractObject(pValue, pExtraArgs, pJsonify);
        }
        catch (ValueFaultHandler.AttributeFilteredException exp) {
            jsonResult = null;
        }
        finally {
            this.clearContext();
        }
        return jsonResult;
    }

    private Object setObjectValue(Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = pInner.getClass();
        if (clazz.isArray()) {
            return this.arrayExtractor.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        Extractor handler = this.getExtractor(clazz);
        if (handler != null) {
            return handler.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + clazz + " for setting object value. (object: " + pInner + ", attribute: " + pAttribute + ", value: " + pValue + ")");
    }

    int getCollectionLength(int originalLength) {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getCollectionSizeTruncated(originalLength);
    }

    String getSerializeLong() {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getSerializeLong();
    }

    public ValueFaultHandler getValueFaultHandler() {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getValueFaultHandler();
    }

    void clearContext() {
        this.stackContextLocal.remove();
    }

    void setupContext() {
        this.setupContext(new SerializeOptions.Builder().build());
    }

    void setupContext(SerializeOptions pOpts) {
        ObjectSerializationContext stackContext = new ObjectSerializationContext(pOpts);
        this.stackContextLocal.set(stackContext);
    }

    private Extractor getExtractor(Class<?> pClazz) {
        for (Extractor handler : this.handlers) {
            if (!handler.canSetValue() || handler.getType() == null || !handler.getType().isAssignableFrom(pClazz)) continue;
            return handler;
        }
        return null;
    }

    private String checkForLimits(Object pValue, ObjectSerializationContext pStackContext) {
        if (pValue != null) {
            if (pStackContext.maxDepthReached()) {
                return pValue.toString();
            }
            if (pStackContext.alreadyVisited(pValue)) {
                return "[Reference " + pValue.getClass().getName() + "@" + Integer.toHexString(pValue.hashCode()) + "]";
            }
        }
        if (pStackContext.maxObjectsExceeded()) {
            return "[Object limit exceeded]";
        }
        return null;
    }

    private Object callHandler(Object pValue, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        Class<?> pClazz = pValue.getClass();
        for (Extractor handler : this.handlers) {
            if (handler.getType() == null || !handler.getType().isAssignableFrom(pClazz)) continue;
            return handler.extractObject(this, pValue, pPathParts, pJsonify);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + pClazz + " (object: " + pValue + ", extraArgs: " + pPathParts + ")");
    }

    ThreadLocal<ObjectSerializationContext> getStackContextLocal() {
        return this.stackContextLocal;
    }

    private void addSimplifiers(List<Extractor> pHandlers) {
        List services = LocalServiceFactory.createServices(this.getClass().getClassLoader(), SIMPLIFIERS_DEFAULT_DEF, SIMPLIFIERS_DEF);
        if (LocalServiceFactory.validateServices(services, this.context)) {
            pHandlers.addAll(services);
        }
    }
}

