/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.SortedSet;
import org.jolokia.jvmagent.JolokiaServer;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.jvmagent.JvmAgentConfig;
import org.jolokia.server.core.detector.ServerDetector;
import org.jolokia.server.core.detector.ServerDetectorLookup;
import org.jolokia.server.core.service.impl.CachingServerDetectorLookup;
import org.jolokia.server.core.service.impl.ClasspathServerDetectorLookup;
import org.jolokia.server.core.service.impl.StdoutLogHandler;

public final class JvmAgent {
    private static JolokiaServer server;
    public static final String JOLOKIA_AGENT_URL = "jolokia.agent";

    private JvmAgent() {
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        JvmAgent.startAgent(new JvmAgentConfig(agentArgs), true, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        JvmAgentConfig config = new JvmAgentConfig(agentArgs);
        if (!config.isModeStop()) {
            JvmAgent.startAgent(config, false, instrumentation);
        } else {
            JvmAgent.stopAgent();
        }
    }

    private static void startAgent(final JvmAgentConfig pConfig, final boolean pLazy, final Instrumentation instrumentation) {
        Thread jolokiaStartThread = new Thread("JolokiaStart"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CachingServerDetectorLookup lookup = new CachingServerDetectorLookup(new ClasspathServerDetectorLookup());
                    ClassLoader loader = JvmAgent.awaitServerInitialization(instrumentation, lookup);
                    pConfig.setClassLoader(loader);
                    server = new JolokiaServer((JolokiaServerConfig)pConfig, lookup);
                    1 var3_4 = this;
                    synchronized (var3_4) {
                        server.start(pLazy);
                        JvmAgent.setStateMarker();
                    }
                    System.out.println("Jolokia: Agent started with URL " + server.getUrl());
                }
                catch (IOException | RuntimeException exp) {
                    System.err.println("Could not start Jolokia agent: " + exp);
                }
            }
        };
        jolokiaStartThread.setDaemon(true);
        System.getLogger("org.jolokia.agent");
        jolokiaStartThread.start();
    }

    private static ClassLoader awaitServerInitialization(Instrumentation instrumentation, ServerDetectorLookup lookup) {
        SortedSet<ServerDetector> detectors = lookup.lookup(new StdoutLogHandler());
        ServerDetector activeDetector = null;
        ClassLoader highOrderClassLoader = null;
        for (ServerDetector detector : detectors) {
            ClassLoader cl = detector.jvmAgentStartup(instrumentation);
            if (cl == null) continue;
            if (highOrderClassLoader != null) {
                System.err.printf("Invalid ServerDetector configuration. Detector \"%s\" already provided a classloader and different detector (\"%s\") overrides it.", activeDetector, detector);
                throw new RuntimeException("Invalid ServerDetector configuration");
            }
            highOrderClassLoader = cl;
            activeDetector = detector;
        }
        return highOrderClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void stopAgent() {
        try {
            if (server == null) return;
            Class<JvmAgent> clazz = JvmAgent.class;
            synchronized (JvmAgent.class) {
                server.stop();
                JvmAgent.clearStateMarker();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
        catch (RuntimeException exp) {
            System.err.println("Could not stop Jolokia agent: " + exp);
            exp.printStackTrace();
        }
    }

    private static void setStateMarker() {
        String url = server.getUrl();
        System.setProperty(JOLOKIA_AGENT_URL, url);
    }

    private static void clearStateMarker() {
        System.clearProperty(JOLOKIA_AGENT_URL);
        System.out.println("Jolokia: Agent stopped");
    }
}

