/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.backend;

import java.io.IOException;
import java.util.SortedSet;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.backend.RequestDispatcher;
import org.jolokia.server.core.backend.RequestDispatcherImpl;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.RequestInterceptor;
import org.jolokia.server.core.service.serializer.SerializeOptions;
import org.jolokia.server.core.service.serializer.Serializer;

public class BackendManager {
    private final JolokiaContext jolokiaCtx;
    private final RequestDispatcher requestDispatcher;
    private SerializeOptions.Builder convertOptionsBuilder;
    private boolean includeRequestGlobal;

    public BackendManager(JolokiaContext pJolokiaCtx) {
        this(pJolokiaCtx, new RequestDispatcherImpl(pJolokiaCtx));
    }

    BackendManager(JolokiaContext pJolokiaCtx, RequestDispatcher pRequestDispatcher) {
        this.jolokiaCtx = pJolokiaCtx;
        this.requestDispatcher = pRequestDispatcher;
        this.init(pJolokiaCtx);
    }

    public JSONObject handleRequest(JolokiaRequest pJmxReq) throws JMException, IOException, EmptyResponseException {
        JSONObject json;
        boolean debug = this.jolokiaCtx.isDebug();
        long time = 0L;
        if (debug) {
            time = System.currentTimeMillis();
        }
        try {
            json = this.callRequestDispatcher(pJmxReq);
            json.put("status", 200);
        }
        catch (NotChangedException exp) {
            json = new JSONObject();
            String includeRequestLocal = pJmxReq.getParameter(ConfigKey.INCLUDE_REQUEST);
            if (this.includeRequestGlobal && !"false".equals(includeRequestLocal) || !this.includeRequestGlobal && "true".equals(includeRequestLocal)) {
                json.put("request", pJmxReq.toJSON());
            }
            json.put("status", 304);
            json.put("timestamp", System.currentTimeMillis() / 1000L);
        }
        this.intercept(pJmxReq, json);
        if (debug) {
            this.jolokiaCtx.debug("Execution time: " + (System.currentTimeMillis() - time) + " ms");
            this.jolokiaCtx.debug("Response: " + json.toJSONString());
        }
        return json;
    }

    private void intercept(JolokiaRequest pJmxReq, JSONObject pRetValue) {
        SortedSet<RequestInterceptor> interceptors = this.jolokiaCtx.getServices(RequestInterceptor.class);
        for (RequestInterceptor interceptor : interceptors) {
            try {
                interceptor.intercept(pJmxReq, pRetValue);
            }
            catch (RuntimeException exp) {
                this.jolokiaCtx.error("Cannot call request logger " + interceptor + ": " + exp, exp);
            }
        }
    }

    public Object convertExceptionToJson(Throwable pExp, JolokiaRequest pJmxReq) {
        SerializeOptions opts = this.getSerializeOptions(pJmxReq);
        try {
            return this.jolokiaCtx.getMandatoryService(Serializer.class).serialize(pExp, null, opts);
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
    }

    private void init(JolokiaContext pCtx) {
        if (pCtx != null) {
            this.convertOptionsBuilder = new SerializeOptions.Builder(this.getNullSaveIntLimit(pCtx.getConfig(ConfigKey.MAX_DEPTH)), this.getNullSaveIntLimit(pCtx.getConfig(ConfigKey.MAX_COLLECTION_SIZE)), this.getNullSaveIntLimit(pCtx.getConfig(ConfigKey.MAX_OBJECTS)));
            this.includeRequestGlobal = pCtx.getConfig(ConfigKey.INCLUDE_REQUEST) == null || Boolean.parseBoolean(pCtx.getConfig(ConfigKey.INCLUDE_REQUEST));
        } else {
            this.convertOptionsBuilder = new SerializeOptions.Builder();
        }
    }

    private int getNullSaveIntLimit(String pValue) {
        return pValue != null ? Integer.parseInt(pValue) : 0;
    }

    private JSONObject callRequestDispatcher(JolokiaRequest pJmxReq) throws JMException, IOException, NotChangedException, EmptyResponseException {
        Object result = this.requestDispatcher.dispatch(pJmxReq);
        SerializeOptions opts = this.getSerializeOptions(pJmxReq);
        Object jsonResult = this.jolokiaCtx.getMandatoryService(Serializer.class).serialize(result, pJmxReq.useReturnValueWithPath() ? pJmxReq.getPathParts() : null, opts);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", jsonResult);
        String includeRequestLocal = pJmxReq.getParameter(ConfigKey.INCLUDE_REQUEST);
        if (this.includeRequestGlobal && !"false".equals(includeRequestLocal) || !this.includeRequestGlobal && "true".equals(includeRequestLocal)) {
            jsonObject.put("request", pJmxReq.toJSON());
        }
        return jsonObject;
    }

    private SerializeOptions getSerializeOptions(JolokiaRequest pJmxReq) {
        return this.convertOptionsBuilder.maxDepth(pJmxReq.getParameterAsInt(ConfigKey.MAX_DEPTH)).maxCollectionSize(pJmxReq.getParameterAsInt(ConfigKey.MAX_COLLECTION_SIZE)).maxObjects(pJmxReq.getParameterAsInt(ConfigKey.MAX_OBJECTS)).serializeLong(pJmxReq.getParameter(ConfigKey.SERIALIZE_LONG)).faultHandler(pJmxReq.getValueFaultHandler()).useAttributeFilter(pJmxReq.getPathParts() != null).build();
    }
}

