/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.SortedSet;
import org.jolokia.jvmagent.JolokiaServer;
import org.jolokia.jvmagent.JvmAgentConfig;
import org.jolokia.server.core.detector.ServerDetector;
import org.jolokia.server.core.service.impl.ClasspathServerDetectorLookup;

public final class JvmAgent {
    private static JolokiaServer server;
    public static final String JOLOKIA_AGENT_URL = "jolokia.agent";

    private JvmAgent() {
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        JvmAgent.startAgent(new JvmAgentConfig(agentArgs), true, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        JvmAgentConfig config = new JvmAgentConfig(agentArgs);
        if (!config.isModeStop()) {
            JvmAgent.startAgent(config, false, instrumentation);
        } else {
            JvmAgent.stopAgent();
        }
    }

    private static void startAgent(final JvmAgentConfig pConfig, final boolean pLazy, final Instrumentation instrumentation) {
        Thread jolokiaStartThread = new Thread("JolokiaStart"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JvmAgent.awaitServerInitialization(instrumentation);
                    JolokiaServer jolokiaServer = server = new JolokiaServer(pConfig);
                    synchronized (jolokiaServer) {
                        server.start(pLazy);
                        JvmAgent.setStateMarker();
                    }
                    System.out.println("Jolokia: Agent started with URL " + server.getUrl());
                }
                catch (IOException | RuntimeException exp) {
                    System.err.println("Could not start Jolokia agent: " + exp);
                }
            }
        };
        jolokiaStartThread.setDaemon(true);
        System.getLogger("org.jolokia.agent");
        jolokiaStartThread.start();
    }

    private static void awaitServerInitialization(Instrumentation instrumentation) {
        SortedSet<ServerDetector> detectors = new ClasspathServerDetectorLookup().lookup();
        for (ServerDetector detector : detectors) {
            detector.jvmAgentStartup(instrumentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopAgent() {
        block5: {
            try {
                if (server == null) break block5;
                JolokiaServer jolokiaServer = server;
                synchronized (jolokiaServer) {
                    server.stop();
                    JvmAgent.clearStateMarker();
                }
            }
            catch (RuntimeException exp) {
                System.err.println("Could not stop Jolokia agent: " + exp);
                exp.printStackTrace();
            }
        }
    }

    private static void setStateMarker() {
        String url = server.getUrl();
        System.setProperty(JOLOKIA_AGENT_URL, url);
    }

    private static void clearStateMarker() {
        System.clearProperty(JOLOKIA_AGENT_URL);
        System.out.println("Jolokia: Agent stopped");
    }
}

