/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;
import org.jolokia.shaded.org.json.simple.JSONArray;

public class ArrayExtractor
implements Extractor {
    @Override
    public Class<?> getType() {
        return null;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        String pathPart;
        int length = pConverter.getCollectionLength(Array.getLength(pValue));
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            return this.extractWithPath(pConverter, pValue, pPathParts, jsonify, pathPart);
        }
        return jsonify ? this.extractArray(pConverter, pValue, pPathParts, jsonify, length) : pValue;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pIndex, Object pValue) throws IllegalAccessException, InvocationTargetException {
        int idx;
        Class<?> clazz = pInner.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Not an array to set a value, but " + clazz + ". (index = " + pIndex + ", value = " + pValue + ")");
        }
        try {
            idx = Integer.parseInt(pIndex);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Non-numeric index for accessing array " + pInner + ". (index = " + pIndex + ", value to set = " + pValue + ")", exp);
        }
        Class<?> type = clazz.getComponentType();
        Object value = pConverter.deserialize(type.getName(), pValue);
        Object oldValue = Array.get(pInner, idx);
        Array.set(pInner, idx, value);
        return oldValue;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    private List<Object> extractArray(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPath, boolean jsonify, int pLength) throws AttributeNotFoundException {
        JSONArray ret = new JSONArray();
        for (int i = 0; i < pLength; ++i) {
            Stack path = (Stack)pPath.clone();
            try {
                Object obj = Array.get(pValue, i);
                ret.add(pConverter.extractObject(obj, path, jsonify));
                continue;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {
                // empty catch block
            }
        }
        if (ret.isEmpty() && pLength > 0) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractWithPath(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPath, boolean jsonify, String pPathPart) throws AttributeNotFoundException {
        try {
            Object obj = Array.get(pValue, Integer.parseInt(pPathPart));
            return pConverter.extractObject(obj, pPath, jsonify);
        }
        catch (NumberFormatException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException(new AttributeNotFoundException("Index '" + pPathPart + "' is not numeric for accessing array"));
        }
        catch (ArrayIndexOutOfBoundsException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException(new AttributeNotFoundException("Index '" + pPathPart + "' is out-of-bound for array of size " + Array.getLength(pValue)));
        }
    }
}

