/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security.asn1;

import org.jolokia.jvmagent.security.asn1.DERObject;

public class DERInteger
implements DERObject {
    private static final byte DER_INTEGER_TAG = 2;
    private final int value;

    public DERInteger(int value) {
        this.value = value;
    }

    @Override
    public byte[] getEncoded() {
        int v = this.value;
        if (this.value < 0) {
            v = -this.value - 1 & Integer.MAX_VALUE;
        }
        if (v < 128) {
            byte[] byArray;
            if (this.value < 0) {
                byte[] byArray2 = new byte[3];
                byArray2[0] = 2;
                byArray2[1] = 1;
                byArray = byArray2;
                byArray2[2] = (byte)(127 - v | 0x80);
            } else {
                byte[] byArray3 = new byte[3];
                byArray3[0] = 2;
                byArray3[1] = 1;
                byArray = byArray3;
                byArray3[2] = (byte)v;
            }
            return byArray;
        }
        if (v < 32768) {
            if (this.value < 0) {
                v = Short.MAX_VALUE - v;
                return new byte[]{2, 2, (byte)((v & 0x7F00) >> 8 | 0x80), (byte)(v & 0xFF)};
            }
            return new byte[]{2, 2, (byte)((v & 0x7F00) >> 8), (byte)(v & 0xFF)};
        }
        if (v < 0x800000) {
            if (this.value < 0) {
                v = 0x7FFFFF - v;
                return new byte[]{2, 3, (byte)((v & 0x7F0000) >> 16 | 0x80), (byte)((v & 0xFF00) >> 8), (byte)(v & 0xFF)};
            }
            return new byte[]{2, 3, (byte)((v & 0x7F0000) >> 16), (byte)((v & 0xFF00) >> 8), (byte)(v & 0xFF)};
        }
        if (this.value < 0) {
            v = Integer.MAX_VALUE - v;
            return new byte[]{2, 4, (byte)((v & 0x7F000000) >> 24 | 0x80), (byte)((v & 0xFF0000) >> 16), (byte)((v & 0xFF00) >> 8), (byte)(v & 0xFF)};
        }
        return new byte[]{2, 4, (byte)((v & 0x7F000000) >> 24), (byte)((v & 0xFF0000) >> 16), (byte)((v & 0xFF00) >> 8), (byte)(v & 0xFF)};
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

