/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.util.function.Consumer;
import jodd.lagarto.CharArrayInput;
import jodd.lagarto.CharSequenceInput;
import jodd.lagarto.CharsInput;
import jodd.lagarto.LagartoParserConfig;
import jodd.lagarto.ParsedDoctype;
import jodd.lagarto.ParsedTag;
import jodd.lagarto.State;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.net.HtmlDecoder;
import jodd.util.ArraysUtil;
import jodd.util.CharUtil;

public class LagartoParser {
    protected TagVisitor visitor;
    protected ParsedTag tag;
    protected ParsedDoctype doctype;
    protected final CharsInput in;
    protected final LagartoParserConfig config;
    protected boolean parsing;
    protected State DATA_STATE = new State(){

        @Override
        public void parse() {
            while (true) {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.emitText();
                    LagartoParser.this.parsing = false;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '<') {
                    LagartoParser.this.emitText();
                    LagartoParser.this.state = LagartoParser.this.TAG_OPEN;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference();
                    continue;
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State TAG_OPEN = new State(){

        @Override
        public void parse() {
            LagartoParser.this.tag.start(LagartoParser.this.in.ndx);
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.textEmitChar('<');
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '!') {
                LagartoParser.this.state = LagartoParser.this.MARKUP_DECLARATION_OPEN;
                return;
            }
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.END_TAG_OPEN;
                return;
            }
            if (CharUtil.isAlpha((char)c)) {
                LagartoParser.this.state = LagartoParser.this.TAG_NAME;
                return;
            }
            if (LagartoParser.this.config.parseXmlTags && LagartoParser.this.in.match(XML)) {
                LagartoParser.this.in.ndx += XML.length - 1;
                if (LagartoParser.this.xmlDeclaration == null) {
                    LagartoParser.this.xmlDeclaration = new XmlDeclaration();
                }
                LagartoParser.this.state = LagartoParser.this.xmlDeclaration.XML_BETWEEN;
                return;
            }
            if (c == '?') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.BOGUS_COMMENT;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.textEmitChar('<');
            --LagartoParser.this.in.ndx;
        }
    };
    protected State END_TAG_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (CharUtil.isAlpha((char)c)) {
                LagartoParser.this.tag.setType(TagType.END);
                LagartoParser.this.state = LagartoParser.this.TAG_NAME;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_COMMENT;
        }
    };
    protected State TAG_NAME = new State(){

        @Override
        public void parse() {
            block4: {
                char c;
                int nameNdx = LagartoParser.this.in.ndx;
                do {
                    ++LagartoParser.this.in.ndx;
                    if (LagartoParser.this.in.isEOF()) {
                        LagartoParser.this.errorEOF();
                        LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                        return;
                    }
                    c = LagartoParser.this.in.charAtNdx();
                    if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                        LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                        LagartoParser.this.tag.setName(LagartoParser.this.in.subSequence(nameNdx, LagartoParser.this.in.ndx));
                    } else {
                        if (c != '/') continue;
                        LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                        LagartoParser.this.tag.setName(LagartoParser.this.in.subSequence(nameNdx, LagartoParser.this.in.ndx));
                    }
                    break block4;
                } while (c != '>');
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.tag.setName(LagartoParser.this.in.subSequence(nameNdx, LagartoParser.this.in.ndx));
                LagartoParser.this.emitTag();
            }
        }
    };
    protected State BEFORE_ATTRIBUTE_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            if (CharUtil.equalsOne((char)c, (char[])ATTR_INVALID_1)) {
                LagartoParser.this.errorInvalidToken();
            }
            LagartoParser.this.state = LagartoParser.this.ATTRIBUTE_NAME;
        }
    };
    protected State ATTRIBUTE_NAME = new State(){

        @Override
        public void parse() {
            LagartoParser.this.attrStartNdx = LagartoParser.this.in.ndx;
            while (true) {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                    LagartoParser.this.attrEndNdx = LagartoParser.this.in.ndx;
                    LagartoParser.this.state = LagartoParser.this.AFTER_ATTRIBUTE_NAME;
                    return;
                }
                if (c == '/') {
                    LagartoParser.this.attrEndNdx = LagartoParser.this.in.ndx;
                    LagartoParser.this._addAttribute();
                    LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                    return;
                }
                if (c == '=') {
                    LagartoParser.this.attrEndNdx = LagartoParser.this.in.ndx;
                    LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_VALUE;
                    return;
                }
                if (c == '>') {
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.attrEndNdx = LagartoParser.this.in.ndx;
                    LagartoParser.this._addAttribute();
                    LagartoParser.this.emitTag();
                    return;
                }
                if (!CharUtil.equalsOne((char)c, (char[])ATTR_INVALID_2)) continue;
                LagartoParser.this.errorInvalidToken();
            }
        }
    };
    protected State AFTER_ATTRIBUTE_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                return;
            }
            if (c == '=') {
                LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_VALUE;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            if (CharUtil.equalsOne((char)c, (char[])ATTR_INVALID_2)) {
                LagartoParser.this.errorInvalidToken();
            }
            LagartoParser.this._addAttribute();
            LagartoParser.this.state = LagartoParser.this.ATTRIBUTE_NAME;
        }
    };
    protected State BEFORE_ATTRIBUTE_VALUE = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
            if (c == '\"') {
                LagartoParser.this.state = LagartoParser.this.ATTR_VALUE_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.state = LagartoParser.this.ATTR_VALUE_SINGLE_QUOTED;
                return;
            }
            if (c == '&') {
                LagartoParser.this.state = LagartoParser.this.ATTR_VALUE_UNQUOTED;
                --LagartoParser.this.in.ndx;
                return;
            }
            if (c == '>') {
                LagartoParser.this._addAttribute();
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            if (CharUtil.equalsOne((char)c, (char[])ATTR_INVALID_3)) {
                LagartoParser.this.errorInvalidToken();
            }
            LagartoParser.this.state = LagartoParser.this.ATTR_VALUE_UNQUOTED;
        }
    };
    protected State ATTR_VALUE_UNQUOTED = new State(){

        @Override
        public void parse() {
            LagartoParser.this.textStart();
            LagartoParser.this.textEmitChar(LagartoParser.this.in.charAtNdx());
            while (true) {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                    LagartoParser.this._addAttributeWithValue();
                    LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference('>');
                    continue;
                }
                if (c == '>') {
                    LagartoParser.this._addAttributeWithValue();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.emitTag();
                    return;
                }
                if (CharUtil.equalsOne((char)c, (char[])ATTR_INVALID_4)) {
                    LagartoParser.this.errorInvalidToken();
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State ATTR_VALUE_SINGLE_QUOTED = new State(){

        @Override
        public void parse() {
            LagartoParser.this.textStart();
            while (true) {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '\'') {
                    LagartoParser.this._addAttributeWithValue();
                    LagartoParser.this.state = LagartoParser.this.AFTER_ATTRIBUTE_VALUE_QUOTED;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference('\'');
                    continue;
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State ATTR_VALUE_DOUBLE_QUOTED = new State(){

        @Override
        public void parse() {
            LagartoParser.this.textStart();
            while (true) {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '\"') {
                    LagartoParser.this._addAttributeWithValue();
                    LagartoParser.this.state = LagartoParser.this.AFTER_ATTRIBUTE_VALUE_QUOTED;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference('\"');
                    continue;
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State AFTER_ATTRIBUTE_VALUE_QUOTED = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                return;
            }
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
            --LagartoParser.this.in.ndx;
        }
    };
    protected State SELF_CLOSING_START_TAG = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '>') {
                LagartoParser.this.tag.setType(TagType.SELF_CLOSING);
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
            --LagartoParser.this.in.ndx;
        }
    };
    protected State BOGUS_COMMENT = new State(){

        @Override
        public void parse() {
            int commentEndNdx = LagartoParser.this.in.find('>');
            if (commentEndNdx == -1) {
                commentEndNdx = LagartoParser.this.in.total;
            }
            LagartoParser.this.emitComment(LagartoParser.this.in.ndx, commentEndNdx);
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.in.ndx = commentEndNdx;
        }
    };
    protected State MARKUP_DECLARATION_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.BOGUS_COMMENT;
                return;
            }
            if (LagartoParser.this.in.match(COMMENT_DASH)) {
                LagartoParser.this.state = LagartoParser.this.COMMENT_START;
                ++LagartoParser.this.in.ndx;
                return;
            }
            if (LagartoParser.this.in.matchUpperCase(T_DOCTYPE)) {
                LagartoParser.this.state = LagartoParser.this.DOCTYPE;
                LagartoParser.this.in.ndx += T_DOCTYPE.length - 1;
                return;
            }
            if (LagartoParser.this.config.enableConditionalComments) {
                if (LagartoParser.this.in.match(CC_IF)) {
                    int ccEndNdx = LagartoParser.this.in.find(CC_END, LagartoParser.this.in.ndx + CC_IF.length);
                    if (ccEndNdx == -1) {
                        ccEndNdx = LagartoParser.this.in.total;
                    }
                    CharSequence expression = LagartoParser.this.in.subSequence(LagartoParser.this.in.ndx + 1, ccEndNdx);
                    LagartoParser.this.conditionalCommentStarted = true;
                    LagartoParser.this.visitor.condComment(expression, true, false, false);
                    LagartoParser.this.in.ndx = ccEndNdx + 1;
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                if (LagartoParser.this.in.match(CC_ENDIF) && LagartoParser.this.conditionalCommentStarted) {
                    LagartoParser.this.in.ndx += CC_ENDIF.length;
                    int ccEndNdx = LagartoParser.this.in.find('>');
                    if (ccEndNdx == -1) {
                        ccEndNdx = LagartoParser.this.in.total;
                    }
                    if (LagartoParser.this.in.match(COMMENT_DASH, ccEndNdx - 2)) {
                        LagartoParser.this.visitor.condComment(_ENDIF, false, true, false);
                    } else {
                        LagartoParser.this.visitor.condComment(_ENDIF, false, false, false);
                    }
                    LagartoParser.this.conditionalCommentStarted = false;
                    LagartoParser.this.in.ndx = ccEndNdx;
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
            }
            if (LagartoParser.this.config.parseXmlTags && LagartoParser.this.in.match(CDATA)) {
                LagartoParser.this.in.ndx += CDATA.length - 1;
                if (LagartoParser.this.xmlDeclaration == null) {
                    LagartoParser.this.xmlDeclaration = new XmlDeclaration();
                }
                LagartoParser.this.state = LagartoParser.this.xmlDeclaration.CDATA;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_COMMENT;
        }
    };
    protected int rawTextStart;
    protected int rawTextEnd;
    protected char[] rawTagName;
    protected State RAWTEXT = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while ((c = LagartoParser.this.in.charAtNdx()) != '<');
            LagartoParser.this.rawTextEnd = LagartoParser.this.in.ndx;
            LagartoParser.this.state = LagartoParser.this.RAWTEXT_LESS_THAN_SIGN;
        }
    };
    protected State RAWTEXT_LESS_THAN_SIGN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.RAWTEXT_END_TAG_OPEN;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.RAWTEXT;
        }
    };
    protected State RAWTEXT_END_TAG_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (CharUtil.isAlpha((char)c)) {
                LagartoParser.this.state = LagartoParser.this.RAWTEXT_END_TAG_NAME;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.RAWTEXT;
        }
    };
    protected State RAWTEXT_END_TAG_NAME = new State(){

        @Override
        public void parse() {
            char c;
            int rawtextEndTagNameStartNdx = LagartoParser.this.in.ndx;
            do {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                    return;
                }
                c = LagartoParser.this.in.charAtNdx();
                if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                    if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rawTagName, rawtextEndTagNameStartNdx, LagartoParser.this.in.ndx)) {
                        LagartoParser.this.textEmitChars(LagartoParser.this.rawTextStart, LagartoParser.this.rawTextEnd);
                        LagartoParser.this.emitText();
                        LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                        LagartoParser.this.tag.start(LagartoParser.this.rawTextEnd);
                        LagartoParser.this.tag.setName(LagartoParser.this.in.subSequence(rawtextEndTagNameStartNdx, LagartoParser.this.in.ndx));
                        LagartoParser.this.tag.setType(TagType.END);
                    } else {
                        LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                    }
                    return;
                }
                if (c == '/') {
                    if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rawTagName, rawtextEndTagNameStartNdx, LagartoParser.this.in.ndx)) {
                        LagartoParser.this.textEmitChars(LagartoParser.this.rawTextStart, LagartoParser.this.rawTextEnd);
                        LagartoParser.this.emitText();
                        LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                        LagartoParser.this.tag.start(LagartoParser.this.rawTextEnd);
                        LagartoParser.this.tag.setName(LagartoParser.this.in.subSequence(rawtextEndTagNameStartNdx, LagartoParser.this.in.ndx));
                        LagartoParser.this.tag.setType(TagType.SELF_CLOSING);
                    } else {
                        LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                    }
                    return;
                }
                if (c != '>') continue;
                if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rawTagName, rawtextEndTagNameStartNdx, LagartoParser.this.in.ndx)) {
                    LagartoParser.this.textEmitChars(LagartoParser.this.rawTextStart, LagartoParser.this.rawTextEnd);
                    LagartoParser.this.emitText();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.tag.start(LagartoParser.this.rawTextEnd);
                    LagartoParser.this.tag.setName(LagartoParser.this.in.subSequence(rawtextEndTagNameStartNdx, LagartoParser.this.in.ndx));
                    LagartoParser.this.tag.setType(TagType.END);
                    LagartoParser.this.tag.end(LagartoParser.this.in.ndx);
                    LagartoParser.this.emitTag();
                } else {
                    LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                }
                return;
            } while (CharUtil.isAlpha((char)c));
            LagartoParser.this.state = LagartoParser.this.RAWTEXT;
        }
    };
    protected int rcdataTagStart = -1;
    protected char[] rcdataTagName;
    protected State RCDATA = new State(){

        @Override
        public void parse() {
            while (true) {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '<') {
                    LagartoParser.this.rcdataTagStart = LagartoParser.this.in.ndx;
                    LagartoParser.this.state = LagartoParser.this.RCDATA_LESS_THAN_SIGN;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference();
                    continue;
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State RCDATA_LESS_THAN_SIGN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.RCDATA;
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.RCDATA_END_TAG_OPEN;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.RCDATA;
            LagartoParser.this.textEmitChar('<');
            LagartoParser.this.textEmitChar(c);
        }
    };
    protected State RCDATA_END_TAG_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.RCDATA;
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (CharUtil.isAlpha((char)c)) {
                LagartoParser.this.state = LagartoParser.this.RCDATA_END_TAG_NAME;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.RCDATA;
            LagartoParser.this.textEmitChar('<');
            LagartoParser.this.textEmitChar('/');
            LagartoParser.this.textEmitChar(c);
        }
    };
    protected State RCDATA_END_TAG_NAME = new State(){

        @Override
        public void parse() {
            char c;
            int rcdataEndTagNameStartNdx = LagartoParser.this.in.ndx;
            do {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.RCDATA;
                    return;
                }
                c = LagartoParser.this.in.charAtNdx();
                if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                    if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rcdataTagName, rcdataEndTagNameStartNdx, LagartoParser.this.in.ndx)) {
                        LagartoParser.this.emitText();
                        LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                        LagartoParser.this.tag.start(LagartoParser.this.rcdataTagStart);
                        LagartoParser.this.tag.setName(LagartoParser.this.in.subSequence(rcdataEndTagNameStartNdx, LagartoParser.this.in.ndx));
                        LagartoParser.this.tag.setType(TagType.END);
                    } else {
                        LagartoParser.this.state = LagartoParser.this.RCDATA;
                    }
                    return;
                }
                if (c == '/') {
                    if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rcdataTagName, rcdataEndTagNameStartNdx, LagartoParser.this.in.ndx)) {
                        LagartoParser.this.emitText();
                        LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                        LagartoParser.this.tag.start(LagartoParser.this.rcdataTagStart);
                        LagartoParser.this.tag.setName(LagartoParser.this.in.subSequence(rcdataEndTagNameStartNdx, LagartoParser.this.in.ndx));
                        LagartoParser.this.tag.setType(TagType.SELF_CLOSING);
                    } else {
                        LagartoParser.this.state = LagartoParser.this.RCDATA;
                    }
                    return;
                }
                if (c != '>') continue;
                if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rcdataTagName, rcdataEndTagNameStartNdx, LagartoParser.this.in.ndx)) {
                    LagartoParser.this.emitText();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.tag.start(LagartoParser.this.rcdataTagStart);
                    LagartoParser.this.tag.setName(LagartoParser.this.in.subSequence(rcdataEndTagNameStartNdx, LagartoParser.this.in.ndx));
                    LagartoParser.this.tag.setType(TagType.END);
                    LagartoParser.this.tag.end(LagartoParser.this.in.ndx);
                    LagartoParser.this.emitTag();
                } else {
                    LagartoParser.this.state = LagartoParser.this.RCDATA;
                }
                return;
            } while (CharUtil.isAlpha((char)c));
            LagartoParser.this.state = LagartoParser.this.RCDATA;
        }
    };
    protected int commentStart;
    protected State COMMENT_START = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            LagartoParser.this.commentStart = LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.total);
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '-') {
                LagartoParser.this.state = LagartoParser.this.COMMENT_START_DASH;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.ndx);
                return;
            }
            LagartoParser.this.state = LagartoParser.this.COMMENT;
        }
    };
    protected State COMMENT_START_DASH = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.total);
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '-') {
                LagartoParser.this.state = LagartoParser.this.COMMENT_END;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.ndx);
            }
            LagartoParser.this.state = LagartoParser.this.COMMENT;
        }
    };
    protected State COMMENT = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.total);
                return;
            } while ((c = LagartoParser.this.in.charAtNdx()) != '-');
            LagartoParser.this.state = LagartoParser.this.COMMENT_END_DASH;
        }
    };
    protected State COMMENT_END_DASH = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.total);
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '-') {
                LagartoParser.this.state = LagartoParser.this.COMMENT_END;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.COMMENT;
        }
    };
    protected State COMMENT_END = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.total);
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.ndx - 2);
                return;
            }
            if (c == '!') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.COMMENT_END_BANG;
                return;
            }
            if (c == '-') {
                LagartoParser.this.errorInvalidToken();
            } else {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.COMMENT;
            }
        }
    };
    protected State COMMENT_END_BANG = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.total);
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '-') {
                LagartoParser.this.state = LagartoParser.this.COMMENT_END_DASH;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.in.ndx - 3);
                return;
            }
            LagartoParser.this.state = LagartoParser.this.COMMENT;
        }
    };
    protected State DOCTYPE = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BEFORE_DOCTYPE_NAME;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BEFORE_DOCTYPE_NAME;
            --LagartoParser.this.in.ndx;
        }
    };
    protected State BEFORE_DOCTYPE_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.state = LagartoParser.this.DOCTYPE_NAME;
        }
    };
    protected State DOCTYPE_NAME = new State(){

        @Override
        public void parse() {
            char c;
            int nameStartNdx = LagartoParser.this.in.ndx;
            do {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.name = LagartoParser.this.in.subSequence(nameStartNdx, LagartoParser.this.in.ndx);
                    LagartoParser.this.doctype.quirksMode = true;
                    LagartoParser.this.emitDoctype();
                    return;
                }
                c = LagartoParser.this.in.charAtNdx();
                if (!CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) continue;
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCUMENT_NAME;
                LagartoParser.this.doctype.name = LagartoParser.this.in.subSequence(nameStartNdx, LagartoParser.this.in.ndx);
                return;
            } while (c != '>');
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.name = LagartoParser.this.in.subSequence(nameStartNdx, LagartoParser.this.in.ndx);
            LagartoParser.this.emitDoctype();
        }
    };
    protected State AFTER_DOCUMENT_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            }
            if (LagartoParser.this.in.matchUpperCase(A_PUBLIC)) {
                LagartoParser.this.in.ndx += A_PUBLIC.length - 1;
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_PUBLIC_KEYWORD;
                return;
            }
            if (LagartoParser.this.in.matchUpperCase(A_SYSTEM)) {
                LagartoParser.this.in.ndx += A_SYSTEM.length - 1;
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_SYSTEM_KEYWORD;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
            LagartoParser.this.doctype.quirksMode = true;
        }
    };
    protected int doctypeIdNameStart;
    protected State AFTER_DOCTYPE_PUBLIC_KEYWORD = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BEFORE_DOCTYPE_PUBLIC_IDENTIFIER;
                return;
            }
            if (c == '\"') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
            LagartoParser.this.doctype.quirksMode = true;
        }
    };
    protected State BEFORE_DOCTYPE_PUBLIC_IDENTIFIER = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
            if (c == '\"') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.doctype.quirksMode = true;
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
        }
    };
    protected State DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.doctype.publicIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.quirksMode = true;
                    LagartoParser.this.emitDoctype();
                }
                if ((c = LagartoParser.this.in.charAtNdx()) != '\"') continue;
                LagartoParser.this.doctype.publicIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_PUBLIC_IDENTIFIER;
                return;
            } while (c != '>');
            LagartoParser.this.doctype.publicIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.quirksMode = true;
            LagartoParser.this.emitDoctype();
        }
    };
    protected State DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.doctype.publicIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.quirksMode = true;
                    LagartoParser.this.emitDoctype();
                }
                if ((c = LagartoParser.this.in.charAtNdx()) != '\'') continue;
                LagartoParser.this.doctype.publicIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_PUBLIC_IDENTIFIER;
                return;
            } while (c != '>');
            LagartoParser.this.doctype.publicIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.quirksMode = true;
            LagartoParser.this.emitDoctype();
        }
    };
    protected State AFTER_DOCTYPE_PUBLIC_IDENTIFIER = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            }
            if (c == '\"') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.doctype.quirksMode = true;
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
        }
    };
    protected State BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            }
            if (c == '\"') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.doctype.quirksMode = true;
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
        }
    };
    protected State BOGUS_DOCTYPE = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            } while ((c = LagartoParser.this.in.charAtNdx()) != '>');
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.emitDoctype();
        }
    };
    protected State AFTER_DOCTYPE_SYSTEM_KEYWORD = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BEFORE_DOCTYPE_SYSTEM_IDENTIFIER;
                return;
            }
            if (c == '\"') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
            LagartoParser.this.doctype.quirksMode = true;
        }
    };
    protected State BEFORE_DOCTYPE_SYSTEM_IDENTIFIER = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
            if (c == '\"') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.in.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.quirksMode = true;
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.doctype.quirksMode = true;
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
        }
    };
    protected State DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.doctype.systemIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.quirksMode = true;
                    LagartoParser.this.emitDoctype();
                }
                if ((c = LagartoParser.this.in.charAtNdx()) != '\"') continue;
                LagartoParser.this.doctype.systemIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_SYSTEM_IDENTIFIER;
                return;
            } while (c != '>');
            LagartoParser.this.doctype.systemIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.quirksMode = true;
            LagartoParser.this.emitDoctype();
        }
    };
    protected State DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.doctype.systemIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.quirksMode = true;
                    LagartoParser.this.emitDoctype();
                }
                if ((c = LagartoParser.this.in.charAtNdx()) != '\'') continue;
                LagartoParser.this.doctype.systemIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_SYSTEM_IDENTIFIER;
                return;
            } while (c != '>');
            LagartoParser.this.doctype.systemIdentifier = LagartoParser.this.in.subSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.in.ndx);
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.quirksMode = true;
            LagartoParser.this.emitDoctype();
        }
    };
    protected State AFTER_DOCTYPE_SYSTEM_IDENTIFIER = new State(){

        @Override
        public void parse() {
            while (true) {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.quirksMode = true;
                    LagartoParser.this.emitDoctype();
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) continue;
                if (c == '>') {
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.emitDoctype();
                    return;
                }
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
            }
        }
    };
    protected int scriptStartNdx = -1;
    protected int scriptEndNdx = -1;
    protected int scriptEndTagName = -1;
    protected State SCRIPT_DATA = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (!LagartoParser.this.in.isEOF()) continue;
                LagartoParser.this.emitScript(LagartoParser.this.scriptStartNdx, LagartoParser.this.in.total);
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while ((c = LagartoParser.this.in.charAtNdx()) != '<');
            LagartoParser.this.scriptEndNdx = LagartoParser.this.in.ndx;
            LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA_LESS_THAN_SIGN;
        }
    };
    protected State SCRIPT_DATA_LESS_THAN_SIGN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                --LagartoParser.this.in.ndx;
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA_END_TAG_OPEN;
                return;
            }
            if (c == '!') {
                if (LagartoParser.this.scriptEscape == null) {
                    LagartoParser.this.scriptEscape = new ScriptEscape();
                }
                LagartoParser.this.state = LagartoParser.this.scriptEscape.SCRIPT_DATA_ESCAPE_START;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
        }
    };
    protected State SCRIPT_DATA_END_TAG_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.in.ndx;
            if (LagartoParser.this.in.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                --LagartoParser.this.in.ndx;
                return;
            }
            char c = LagartoParser.this.in.charAtNdx();
            if (CharUtil.isAlpha((char)c)) {
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA_END_TAG_NAME;
                LagartoParser.this.scriptEndTagName = LagartoParser.this.in.ndx;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
        }
    };
    protected State SCRIPT_DATA_END_TAG_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                c = LagartoParser.this.in.charAtNdx();
                if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                    LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.in.ndx) ? LagartoParser.this.BEFORE_ATTRIBUTE_NAME : LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                if (c == '/') {
                    LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.in.ndx) ? LagartoParser.this.SELF_CLOSING_START_TAG : LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                if (c != '>') continue;
                if (LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.in.ndx)) {
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.emitScript(LagartoParser.this.scriptStartNdx, LagartoParser.this.scriptEndNdx);
                } else {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                }
                return;
            } while (CharUtil.isAlpha((char)c));
            LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
        }
    };
    protected ScriptEscape scriptEscape = null;
    protected XmlDeclaration xmlDeclaration = null;
    protected char[] text;
    protected int textLen;
    protected int attrStartNdx = -1;
    protected int attrEndNdx = -1;
    private boolean conditionalCommentStarted = false;
    protected State state = this.DATA_STATE;
    private static final char[] TAG_WHITESPACES = new char[]{'\t', '\n', '\r', ' '};
    private static final char[] TAG_WHITESPACES_OR_END = new char[]{'\t', '\n', '\r', ' ', '/', '>'};
    private static final char[] CONTINUE_CHARS = new char[]{'\t', '\n', '\r', ' ', '<', '&'};
    private static final char[] ATTR_INVALID_1 = new char[]{'\"', '\'', '<', '='};
    private static final char[] ATTR_INVALID_2 = new char[]{'\"', '\'', '<'};
    private static final char[] ATTR_INVALID_3 = new char[]{'<', '=', '`'};
    private static final char[] ATTR_INVALID_4 = new char[]{'\"', '\'', '<', '=', '`'};
    private static final char[] COMMENT_DASH = new char[]{'-', '-'};
    private static final char[] T_DOCTYPE = new char[]{'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    private static final char[] T_SCRIPT = new char[]{'s', 'c', 'r', 'i', 'p', 't'};
    private static final char[] T_XMP = new char[]{'x', 'm', 'p'};
    private static final char[] T_STYLE = new char[]{'s', 't', 'y', 'l', 'e'};
    private static final char[] T_IFRAME = new char[]{'i', 'f', 'r', 'a', 'm', 'e'};
    private static final char[] T_NOFRAMES = new char[]{'n', 'o', 'f', 'r', 'a', 'm', 'e', 's'};
    private static final char[] T_NOEMBED = new char[]{'n', 'o', 'e', 'm', 'b', 'e', 'd'};
    private static final char[] T_NOSCRIPT = new char[]{'n', 'o', 's', 'c', 'r', 'i', 'p', 't'};
    private static final char[] T_TEXTAREA = new char[]{'t', 'e', 'x', 't', 'a', 'r', 'e', 'a'};
    private static final char[] T_TITLE = new char[]{'t', 'i', 't', 'l', 'e'};
    private static final char[] A_PUBLIC = new char[]{'P', 'U', 'B', 'L', 'I', 'C'};
    private static final char[] A_SYSTEM = new char[]{'S', 'Y', 'S', 'T', 'E', 'M'};
    private static final char[] CDATA = new char[]{'[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] CDATA_END = new char[]{']', ']', '>'};
    private static final char[] XML = new char[]{'?', 'x', 'm', 'l'};
    private static final char[] XML_VERSION = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n'};
    private static final char[] XML_ENCODING = new char[]{'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g'};
    private static final char[] XML_STANDALONE = new char[]{'s', 't', 'a', 'n', 'd', 'a', 'l', 'o', 'n', 'e'};
    private static final char[] CC_IF = new char[]{'[', 'i', 'f', ' '};
    private static final char[] CC_ENDIF = new char[]{'[', 'e', 'n', 'd', 'i', 'f', ']'};
    private static final char[] CC_ENDIF2 = new char[]{'<', '!', '[', 'e', 'n', 'd', 'i', 'f', ']'};
    private static final char[] CC_END = new char[]{']', '>'};
    private static final char[][] RAWTEXT_TAGS = new char[][]{T_XMP, T_STYLE, T_IFRAME, T_NOEMBED, T_NOFRAMES, T_NOSCRIPT, T_SCRIPT};
    private static final char[][] RCDATA_TAGS = new char[][]{T_TEXTAREA, T_TITLE};
    private static final char REPLACEMENT_CHAR = '\ufffd';
    private static final char[] INVALID_CHARS = new char[]{'\u000b', '\ufffe', '\uffff'};
    private static final CharSequence _ENDIF = "endif";

    public LagartoParser(LagartoParserConfig parserConfig, char[] input) {
        this.config = parserConfig;
        this.in = new CharArrayInput(input);
        this.initialize();
    }

    public LagartoParser(char[] input) {
        this(new LagartoParserConfig(), input);
    }

    public LagartoParser(LagartoParserConfig parserConfig, CharSequence input) {
        this.config = parserConfig;
        this.in = new CharSequenceInput(input);
        this.initialize();
    }

    public LagartoParser(CharSequence input) {
        this(new LagartoParserConfig(), input);
    }

    protected void initialize() {
        this.tag = new ParsedTag();
        this.doctype = new ParsedDoctype();
        this.text = new char[this.config.getTextBufferSize()];
        this.textLen = 0;
    }

    public LagartoParserConfig getConfig() {
        return this.config;
    }

    public LagartoParser configure(Consumer<LagartoParserConfig> configConsumer) {
        configConsumer.accept(this.config);
        return this;
    }

    public void parse(TagVisitor visitor) {
        this.tag.init(this.config.caseSensitive);
        this.visitor = visitor;
        visitor.start();
        this.parsing = true;
        while (this.parsing) {
            this.state.parse();
        }
        this.emitText();
        visitor.end();
    }

    protected void consumeCharacterReference(char allowedChar) {
        ++this.in.ndx;
        if (this.in.isEOF()) {
            return;
        }
        char c = this.in.charAtNdx();
        if (c == allowedChar) {
            --this.in.ndx;
            return;
        }
        this._consumeAttrCharacterReference();
    }

    protected void consumeCharacterReference() {
        ++this.in.ndx;
        if (this.in.isEOF()) {
            return;
        }
        this._consumeCharacterReference();
    }

    private void _consumeCharacterReference() {
        int unconsumeNdx = this.in.ndx - 1;
        char c = this.in.charAtNdx();
        if (CharUtil.equalsOne((char)c, (char[])CONTINUE_CHARS)) {
            this.in.ndx = unconsumeNdx;
            this.textEmitChar('&');
            return;
        }
        if (c == '#') {
            this._consumeNumber(unconsumeNdx);
        } else {
            String name = this.in.decodeHtmlName();
            if (name == null) {
                this.errorCharReference();
                this.textEmitChar('&');
                this.in.ndx = unconsumeNdx;
                return;
            }
            this.in.ndx += name.length();
            this.textEmitChars(HtmlDecoder.lookup((String)name));
            c = this.in.charAtNdx();
            if (c != ';') {
                this.errorCharReference();
                --this.in.ndx;
            }
        }
    }

    private void _consumeAttrCharacterReference() {
        int unconsumeNdx = this.in.ndx - 1;
        char c = this.in.charAtNdx();
        if (CharUtil.equalsOne((char)c, (char[])CONTINUE_CHARS)) {
            this.in.ndx = unconsumeNdx;
            this.textEmitChar('&');
            return;
        }
        if (c == '#') {
            this._consumeNumber(unconsumeNdx);
        } else {
            String name = this.in.decodeHtmlName();
            if (name == null) {
                this.errorCharReference();
                this.textEmitChar('&');
                this.in.ndx = unconsumeNdx;
                return;
            }
            this.in.ndx += name.length();
            c = this.in.charAtNdx();
            if (c == ';') {
                this.textEmitChars(HtmlDecoder.lookup((String)name));
            } else {
                this.textEmitChar('&');
                this.in.ndx = unconsumeNdx;
            }
        }
    }

    private void _consumeNumber(int unconsumeNdx) {
        ++this.in.ndx;
        if (this.in.isEOF()) {
            this.in.ndx = unconsumeNdx;
            return;
        }
        char c = this.in.charAtNdx();
        int value = 0;
        int digitCount = 0;
        if (c == 'X' || c == 'x') {
            while (true) {
                ++this.in.ndx;
                if (this.in.isEOF()) {
                    this.in.ndx = unconsumeNdx;
                    return;
                }
                c = this.in.charAtNdx();
                if (CharUtil.isDigit((char)c)) {
                    value *= 16;
                    value += c - 48;
                    ++digitCount;
                    continue;
                }
                if (c >= 'a' && c <= 'f') {
                    value *= 16;
                    value += c - 97 + 10;
                    ++digitCount;
                    continue;
                }
                if (c >= 'A' && c <= 'F') {
                    value *= 16;
                    value += c - 65 + 10;
                    ++digitCount;
                    continue;
                }
                break;
            }
        } else {
            while (CharUtil.isDigit((char)c)) {
                value *= 10;
                value += c - 48;
                ++this.in.ndx;
                if (this.in.isEOF()) {
                    this.in.ndx = unconsumeNdx;
                    return;
                }
                c = this.in.charAtNdx();
                ++digitCount;
            }
        }
        if (digitCount == 0) {
            this.errorCharReference();
            this.in.ndx = unconsumeNdx;
            return;
        }
        if (c != ';') {
            this.errorCharReference();
            --this.in.ndx;
        }
        boolean isErr = true;
        switch (value) {
            case 0: {
                c = '\ufffd';
                break;
            }
            case 128: {
                c = '\u20ac';
                break;
            }
            case 129: {
                c = '\u0081';
                break;
            }
            case 130: {
                c = '\u201a';
                break;
            }
            case 131: {
                c = '\u0192';
                break;
            }
            case 132: {
                c = '\u201e';
                break;
            }
            case 133: {
                c = '\u2026';
                break;
            }
            case 134: {
                c = '\u2020';
                break;
            }
            case 135: {
                c = '\u2021';
                break;
            }
            case 136: {
                c = '\u02c6';
                break;
            }
            case 137: {
                c = '\u2030';
                break;
            }
            case 138: {
                c = '\u0160';
                break;
            }
            case 139: {
                c = '\u2039';
                break;
            }
            case 140: {
                c = '\u0152';
                break;
            }
            case 141: {
                c = '\u008d';
                break;
            }
            case 142: {
                c = '\u017d';
                break;
            }
            case 143: {
                c = '\u008f';
                break;
            }
            case 144: {
                c = '\u0090';
                break;
            }
            case 145: {
                c = '\u2018';
                break;
            }
            case 146: {
                c = '\u2019';
                break;
            }
            case 147: {
                c = '\u201c';
                break;
            }
            case 148: {
                c = '\u201d';
                break;
            }
            case 149: {
                c = '\u2022';
                break;
            }
            case 150: {
                c = '\u2013';
                break;
            }
            case 151: {
                c = '\u2014';
                break;
            }
            case 152: {
                c = '\u02dc';
                break;
            }
            case 153: {
                c = '\u2122';
                break;
            }
            case 154: {
                c = '\u0161';
                break;
            }
            case 155: {
                c = '\u203a';
                break;
            }
            case 156: {
                c = '\u0153';
                break;
            }
            case 157: {
                c = '\u009d';
                break;
            }
            case 158: {
                c = '\u017e';
                break;
            }
            case 159: {
                c = '\u0178';
                break;
            }
            default: {
                isErr = false;
            }
        }
        if (isErr) {
            this.errorCharReference();
            this.textEmitChar(c);
            return;
        }
        if (value >= 55296 && value <= 57343 || value > 0x10FFFF) {
            this.errorCharReference();
            this.textEmitChar('\ufffd');
            return;
        }
        c = (char)value;
        this.textEmitChar(c);
        if (c >= '\u0001' && c <= '\b' || c >= '\r' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufdef') {
            this.errorCharReference();
            return;
        }
        if (CharUtil.equalsOne((char)c, (char[])INVALID_CHARS)) {
            this.errorCharReference();
        }
    }

    private void ensureCapacity() {
        if (this.textLen == this.text.length) {
            this.text = ArraysUtil.resize((char[])this.text, (int)(this.textLen << 1));
        }
    }

    private void ensureCapacity(int growth) {
        int desiredLen = this.textLen + growth;
        if (desiredLen > this.text.length) {
            this.text = ArraysUtil.resize((char[])this.text, (int)Math.max(this.textLen << 1, desiredLen));
        }
    }

    protected void textEmitChar(char c) {
        this.ensureCapacity();
        this.text[this.textLen++] = c;
    }

    protected void textStart() {
        this.textLen = 0;
    }

    protected void textEmitChars(int from, int to) {
        this.ensureCapacity(to - from);
        while (from < to) {
            this.text[this.textLen++] = this.in.charAt(from++);
        }
    }

    protected void textEmitChars(char[] buffer) {
        this.ensureCapacity(buffer.length);
        for (char aBuffer : buffer) {
            this.text[this.textLen++] = aBuffer;
        }
    }

    protected CharSequence textWrap() {
        if (this.textLen == 0) {
            return CharArrayInput.EMPTY_CHAR_SEQUENCE;
        }
        return new String(this.text, 0, this.textLen);
    }

    private void _addAttribute() {
        this._addAttribute(this.in.subSequence(this.attrStartNdx, this.attrEndNdx), null);
    }

    private void _addAttributeWithValue() {
        this._addAttribute(this.in.subSequence(this.attrStartNdx, this.attrEndNdx), this.textWrap().toString());
    }

    private void _addAttribute(CharSequence attrName, CharSequence attrValue) {
        if (this.tag.getType() == TagType.END) {
            this._error("Ignored end tag attribute");
        } else if (this.tag.hasAttribute(attrName)) {
            this._error("Ignored duplicated attribute: " + attrName);
        } else {
            this.tag.addAttribute(attrName, attrValue);
        }
        this.attrStartNdx = -1;
        this.attrEndNdx = -1;
        this.textLen = 0;
    }

    protected void emitTag() {
        this.tag.end(this.in.ndx + 1);
        if (this.config.calculatePosition) {
            this.tag.setPosition(this.in.positionOf(this.tag.getTagPosition()));
        }
        if (this.tag.getType().isStartingTag()) {
            if (this.matchTagName(T_SCRIPT)) {
                this.scriptStartNdx = this.in.ndx + 1;
                this.state = this.SCRIPT_DATA;
                return;
            }
            if (this.config.enableRawTextModes) {
                for (char[] rawtextTagName : RAWTEXT_TAGS) {
                    if (!this.matchTagName(rawtextTagName)) continue;
                    this.tag.setRawTag(true);
                    this.state = this.RAWTEXT;
                    this.rawTextStart = this.in.ndx + 1;
                    this.rawTagName = rawtextTagName;
                    break;
                }
                for (char[] rcdataTextTagName : RCDATA_TAGS) {
                    if (!this.matchTagName(rcdataTextTagName)) continue;
                    this.state = this.RCDATA;
                    this.rcdataTagStart = this.in.ndx + 1;
                    this.rcdataTagName = rcdataTextTagName;
                    break;
                }
            }
            this.tag.increaseDeepLevel();
        }
        this.visitor.tag(this.tag);
        if (this.tag.getType().isEndingTag()) {
            this.tag.decreaseDeepLevel();
        }
    }

    protected void emitComment(int from, int to) {
        if (from == -1) {
            this.visitor.comment(CharArrayInput.EMPTY_CHAR_SEQUENCE);
            return;
        }
        if (this.config.enableConditionalComments) {
            if (this.in.match(CC_IF, from)) {
                int endBracketNdx = this.in.find(']', from + 3, to);
                if (endBracketNdx == -1) {
                    CharSequence comment = this.in.subSequence(from, to);
                    this.visitor.comment(comment);
                    this.commentStart = -1;
                    return;
                }
                CharSequence expression = this.in.subSequence(from + 1, endBracketNdx);
                this.in.ndx = endBracketNdx + 1;
                char c = this.in.charAtNdx();
                if (c != '>') {
                    this.errorInvalidToken();
                }
                this.conditionalCommentStarted = true;
                this.visitor.condComment(expression, true, true, false);
                this.state = this.DATA_STATE;
                return;
            }
            if (to > CC_ENDIF2.length && this.in.match(CC_ENDIF2, to - CC_ENDIF2.length) && this.conditionalCommentStarted) {
                this.visitor.condComment(_ENDIF, false, true, true);
                this.conditionalCommentStarted = false;
                this.state = this.DATA_STATE;
                return;
            }
        }
        CharSequence comment = this.in.subSequence(from, to);
        this.visitor.comment(comment);
        this.commentStart = -1;
    }

    protected void emitText() {
        if (this.textLen != 0) {
            this.visitor.text(this.textWrap());
        }
        this.textLen = 0;
    }

    protected void emitScript(int from, int to) {
        this.tag.increaseDeepLevel();
        this.tag.setRawTag(true);
        this.visitor.script(this.tag, this.in.subSequence(from, to));
        this.tag.decreaseDeepLevel();
        this.scriptStartNdx = -1;
        this.scriptEndNdx = -1;
    }

    protected void emitDoctype() {
        this.visitor.doctype(this.doctype);
        this.doctype.reset();
    }

    protected void emitXml() {
        this.visitor.xml(this.xmlDeclaration.version, this.xmlDeclaration.encoding, this.xmlDeclaration.standalone);
        this.xmlDeclaration.reset();
    }

    protected void emitCData(CharSequence charSequence) {
        this.visitor.cdata(charSequence);
    }

    protected void errorEOF() {
        this._error("Parse error: EOF");
    }

    protected void errorInvalidToken() {
        this._error("Parse error: invalid token");
    }

    protected void errorCharReference() {
        this._error("Parse error: invalid character reference");
    }

    protected void _error(String message) {
        if (this.config.calculatePosition) {
            CharsInput.Position currentPosition = this.in.positionOf(this.in.ndx);
            message = message.concat(" ").concat(currentPosition.toString());
        } else {
            message = message.concat(" [@").concat(Integer.toString(this.in.ndx)).concat("]");
        }
        this.visitor.error(message);
    }

    private boolean isAppropriateTagName(char[] lowerCaseNameToMatch, int from, int to) {
        int len = to - from;
        if (len != lowerCaseNameToMatch.length) {
            return false;
        }
        int i = from;
        int k = 0;
        while (i < to) {
            char c = this.in.charAt(i);
            if ((c = CharUtil.toLowerAscii((char)c)) != lowerCaseNameToMatch[k]) {
                return false;
            }
            ++i;
            ++k;
        }
        return true;
    }

    private boolean matchTagName(char[] tagNameLowercase) {
        CharSequence charSequence = this.tag.getName();
        int length = tagNameLowercase.length;
        if (charSequence.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = charSequence.charAt(i);
            if ((c = CharUtil.toLowerAscii((char)c)) == tagNameLowercase[i]) continue;
            return false;
        }
        return true;
    }

    protected class XmlDeclaration {
        protected int xmlAttrCount = 0;
        protected int xmlAttrStartNdx = -1;
        protected CharSequence version;
        protected CharSequence encoding;
        protected CharSequence standalone;
        protected char attrQuote;
        protected State XML_BETWEEN = new State(){

            @Override
            public void parse() {
                while (true) {
                    ++LagartoParser.this.in.ndx;
                    if (LagartoParser.this.in.isEOF()) {
                        LagartoParser.this.errorEOF();
                        LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                        return;
                    }
                    char c = LagartoParser.this.in.charAtNdx();
                    if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) continue;
                    if (c == '?') {
                        LagartoParser.this.state = XmlDeclaration.this.XML_CLOSE;
                        return;
                    }
                    switch (XmlDeclaration.this.xmlAttrCount) {
                        case 0: {
                            if (!LagartoParser.this.in.match(XML_VERSION)) break;
                            LagartoParser.this.in.ndx += XML_VERSION.length - 1;
                            LagartoParser.this.state = XmlDeclaration.this.AFTER_XML_ATTRIBUTE_NAME;
                            return;
                        }
                        case 1: {
                            if (!LagartoParser.this.in.match(XML_ENCODING)) break;
                            LagartoParser.this.in.ndx += XML_ENCODING.length - 1;
                            LagartoParser.this.state = XmlDeclaration.this.AFTER_XML_ATTRIBUTE_NAME;
                            return;
                        }
                        case 2: {
                            if (!LagartoParser.this.in.match(XML_STANDALONE)) break;
                            LagartoParser.this.in.ndx += XML_STANDALONE.length - 1;
                            LagartoParser.this.state = XmlDeclaration.this.AFTER_XML_ATTRIBUTE_NAME;
                            return;
                        }
                    }
                    LagartoParser.this.errorInvalidToken();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                }
            }
        };
        protected State AFTER_XML_ATTRIBUTE_NAME = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.in.ndx;
                    if (!LagartoParser.this.in.isEOF()) continue;
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
                if (c == '=') {
                    LagartoParser.this.state = XmlDeclaration.this.BEFORE_XML_ATTRIBUTE_VALUE;
                    return;
                }
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            }
        };
        protected State BEFORE_XML_ATTRIBUTE_VALUE = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.in.ndx;
                    if (!LagartoParser.this.in.isEOF()) continue;
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                } while (CharUtil.equalsOne((char)(c = LagartoParser.this.in.charAtNdx()), (char[])TAG_WHITESPACES));
                if (c == '\"' || c == '\'') {
                    LagartoParser.this.state = XmlDeclaration.this.XML_ATTRIBUTE_VALUE;
                    XmlDeclaration.this.attrQuote = c;
                    return;
                }
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            }
        };
        protected State XML_ATTRIBUTE_VALUE = new State(){

            @Override
            public void parse() {
                char c;
                XmlDeclaration.this.xmlAttrStartNdx = LagartoParser.this.in.ndx + 1;
                do {
                    ++LagartoParser.this.in.ndx;
                    if (!LagartoParser.this.in.isEOF()) continue;
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                } while ((c = LagartoParser.this.in.charAtNdx()) != XmlDeclaration.this.attrQuote);
                CharSequence value = LagartoParser.this.in.subSequence(XmlDeclaration.this.xmlAttrStartNdx, LagartoParser.this.in.ndx);
                switch (XmlDeclaration.this.xmlAttrCount) {
                    case 0: {
                        XmlDeclaration.this.version = value;
                        break;
                    }
                    case 1: {
                        XmlDeclaration.this.encoding = value;
                        break;
                    }
                    case 2: {
                        XmlDeclaration.this.standalone = value;
                    }
                }
                ++XmlDeclaration.this.xmlAttrCount;
                LagartoParser.this.state = XmlDeclaration.this.XML_BETWEEN;
            }
        };
        protected State XML_CLOSE = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '>') {
                    LagartoParser.this.emitXml();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            }
        };
        protected State CDATA = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                int cdataEndNdx = LagartoParser.this.in.find(CDATA_END, LagartoParser.this.in.ndx);
                if (cdataEndNdx == -1) {
                    cdataEndNdx = LagartoParser.this.in.total;
                }
                CharSequence cdata = LagartoParser.this.in.subSequence(LagartoParser.this.in.ndx, cdataEndNdx);
                LagartoParser.this.emitCData(cdata);
                LagartoParser.this.in.ndx = cdataEndNdx + 2;
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            }
        };

        protected XmlDeclaration() {
        }

        protected void reset() {
            this.xmlAttrCount = 0;
            this.xmlAttrStartNdx = -1;
            this.standalone = null;
            this.encoding = null;
            this.version = null;
        }
    }

    protected class ScriptEscape {
        protected int doubleEscapedNdx = -1;
        protected int doubleEscapedEndTag = -1;
        protected State SCRIPT_DATA_ESCAPE_START = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    --LagartoParser.this.in.ndx;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '-') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPE_START_DASH;
                    return;
                }
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
            }
        };
        protected State SCRIPT_DATA_ESCAPE_START_DASH = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '-') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_DASH_DASH;
                    return;
                }
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_DASH_DASH = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '-') {
                    return;
                }
                if (c == '<') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;
                    return;
                }
                if (c == '>') {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '/') {
                    ScriptEscape.this.doubleEscapedNdx = -1;
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_END_TAG_OPEN;
                    return;
                }
                if (CharUtil.isAlpha((char)c)) {
                    ScriptEscape.this.doubleEscapedNdx = LagartoParser.this.in.ndx;
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPE_START;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_ESCAPED = new State(){

            @Override
            public void parse() {
                block2: {
                    char c;
                    do {
                        ++LagartoParser.this.in.ndx;
                        if (LagartoParser.this.in.isEOF()) {
                            LagartoParser.this.errorEOF();
                            LagartoParser.this.emitScript(LagartoParser.this.scriptStartNdx, LagartoParser.this.in.total);
                            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                            return;
                        }
                        c = LagartoParser.this.in.charAtNdx();
                        if (c == '-') break block2;
                    } while (c != '<');
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_DASH;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_DASH = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '-') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_DASH_DASH;
                    return;
                }
                if (c == '<') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_DASH_DASH;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_END_TAG_OPEN = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (CharUtil.isAlpha((char)c)) {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_END_TAG_NAME;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_END_TAG_NAME = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.in.ndx;
                    if (LagartoParser.this.in.isEOF()) {
                        LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                        return;
                    }
                    c = LagartoParser.this.in.charAtNdx();
                    if (CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES)) {
                        LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.in.ndx) ? LagartoParser.this.BEFORE_ATTRIBUTE_NAME : ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                        return;
                    }
                    if (c == '/') {
                        LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.in.ndx) ? LagartoParser.this.SELF_CLOSING_START_TAG : ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                        return;
                    }
                    if (c != '>') continue;
                    if (LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.in.ndx)) {
                        LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                        LagartoParser.this.emitTag();
                    } else {
                        LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                    }
                    return;
                } while (CharUtil.isAlpha((char)c));
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPE_START = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.in.ndx;
                    if (LagartoParser.this.in.isEOF()) {
                        LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                        return;
                    }
                    c = LagartoParser.this.in.charAtNdx();
                    if (!CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES_OR_END)) continue;
                    LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, ScriptEscape.this.doubleEscapedNdx, LagartoParser.this.in.ndx) ? ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED : ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                    return;
                } while (CharUtil.isAlpha((char)c));
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPED = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.in.ndx;
                    if (LagartoParser.this.in.isEOF()) {
                        LagartoParser.this.errorEOF();
                        LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                        return;
                    }
                    c = LagartoParser.this.in.charAtNdx();
                    if (c != '-') continue;
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_DASH;
                    return;
                } while (c != '<');
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPED_DASH = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '-') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH;
                    return;
                }
                if (c == '<') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.in.ndx;
                    if (!LagartoParser.this.in.isEOF()) continue;
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                } while ((c = LagartoParser.this.in.charAtNdx()) == '-');
                if (c == '<') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN;
                    return;
                }
                if (c == '>') {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.in.ndx;
                if (LagartoParser.this.in.isEOF()) {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
                    return;
                }
                char c = LagartoParser.this.in.charAtNdx();
                if (c == '/') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPE_END;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPE_END = new State(){

            @Override
            public void parse() {
                char c;
                ScriptEscape.this.doubleEscapedEndTag = LagartoParser.this.in.ndx + 1;
                do {
                    ++LagartoParser.this.in.ndx;
                    if (LagartoParser.this.in.isEOF()) {
                        LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
                        return;
                    }
                    c = LagartoParser.this.in.charAtNdx();
                    if (!CharUtil.equalsOne((char)c, (char[])TAG_WHITESPACES_OR_END)) continue;
                    LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, ScriptEscape.this.doubleEscapedEndTag, LagartoParser.this.in.ndx) ? ScriptEscape.this.SCRIPT_DATA_ESCAPED : ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
                    return;
                } while (CharUtil.isAlpha((char)c));
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
            }
        };

        protected ScriptEscape() {
        }
    }
}

