/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import jodd.lagarto.HtmlDecoder;
import jodd.util.CharUtil;

abstract class CharsInput
implements CharSequence {
    protected int ndx;
    protected final int total;
    private int lastOffset = -1;
    private int lastLine;
    private int lastLastNewLineOffset;

    public CharsInput(int total) {
        this.total = total;
        this.ndx = -1;
    }

    @Override
    public int length() {
        return this.total;
    }

    public abstract char charAtNdx();

    public final int find(char target) {
        return this.find(target, this.ndx, this.total);
    }

    public final int find(char target, int from, int end) {
        while (from < end && this.charAt(from) != target) {
            ++from;
        }
        return from == end ? -1 : from;
    }

    public final int find(char[] target, int from) {
        return this.find(target, from, this.total);
    }

    public final int find(char[] target, int from, int end) {
        while (from < end && !this.match(target, from)) {
            ++from;
        }
        return from == end ? -1 : from;
    }

    protected final boolean match(char[] target, int ndx) {
        if (ndx + target.length >= this.total) {
            return false;
        }
        int j = ndx;
        int i = 0;
        while (i < target.length) {
            if (this.charAt(j) != target[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public final boolean match(char[] target) {
        return this.match(target, this.ndx);
    }

    public final boolean matchUpperCase(char[] uppercaseTarget) {
        if (this.ndx + uppercaseTarget.length > this.total) {
            return false;
        }
        int j = this.ndx;
        int i = 0;
        while (i < uppercaseTarget.length) {
            char c = CharUtil.toUpperAscii((char)this.charAt(j));
            if (c != uppercaseTarget[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public String decodeHtmlName() {
        return HtmlDecoder.detectName(this, this.ndx);
    }

    protected final boolean isEOF() {
        return this.ndx >= this.total;
    }

    protected Position positionOf(int index) {
        int lastNewLineOffset;
        int offset;
        int line;
        if (index > this.lastOffset) {
            line = 1;
            offset = 0;
            lastNewLineOffset = 0;
        } else {
            line = this.lastLine;
            offset = this.lastOffset;
            lastNewLineOffset = this.lastLastNewLineOffset;
        }
        while (offset < index) {
            char c = this.charAt(offset);
            if (c == '\n') {
                ++line;
                lastNewLineOffset = offset + 1;
            }
            ++offset;
        }
        this.lastOffset = offset;
        this.lastLine = line;
        this.lastLastNewLineOffset = lastNewLineOffset;
        return new Position(index, line, index - lastNewLineOffset + 1);
    }

    public static class Position {
        private final int offset;
        private final int line;
        private final int column;

        public Position(int offset, int line, int column) {
            this.offset = offset;
            this.line = line;
            this.column = column;
        }

        public String toString() {
            if (this.offset == -1) {
                return "[" + this.line + ':' + this.column + ']';
            }
            if (this.line == -1) {
                return "[@" + this.offset + ']';
            }
            return "[" + this.line + ':' + this.column + " @" + this.offset + ']';
        }
    }
}

