/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import java.util.Arrays;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class CharObjectArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new CharObjectArrayStringConverterFactory();

    private CharObjectArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls == Character[].class) {
            return CharecterArrayStringConverter.INSTANCE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum CharecterArrayStringConverter implements TypedStringConverter<Character[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Character[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                for (Character element : array) {
                    if (element == null) {
                        buf.append("\\-");
                        continue;
                    }
                    char ch = element.charValue();
                    if (ch == '\\') {
                        buf.append("\\\\");
                        continue;
                    }
                    buf.append(ch);
                }
                return buf.toString();
            }

            @Override
            public Character[] convertFromString(Class<? extends Character[]> cls, String str) {
                int i;
                int pos;
                if (str.length() == 0) {
                    return EMPTY;
                }
                String adjusted = str;
                Character[] array = new Character[adjusted.length()];
                int arrayPos = 0;
                while ((pos = adjusted.indexOf(92)) >= 0) {
                    for (i = 0; i < pos; ++i) {
                        array[arrayPos++] = Character.valueOf(adjusted.charAt(i));
                    }
                    if (adjusted.charAt(pos + 1) == '\\') {
                        array[arrayPos++] = Character.valueOf('\\');
                    } else if (adjusted.charAt(pos + 1) == '-') {
                        array[arrayPos++] = null;
                    } else {
                        throw new IllegalArgumentException("Invalid Character[] string, incorrect escape");
                    }
                    adjusted = adjusted.substring(pos + 2);
                }
                for (i = 0; i < adjusted.length(); ++i) {
                    array[arrayPos++] = Character.valueOf(adjusted.charAt(i));
                }
                return Arrays.copyOf(array, arrayPos);
            }

            @Override
            public Class<?> getEffectiveType() {
                return Character[].class;
            }
        };

        private static final Character[] EMPTY;

        static {
            EMPTY = new Character[0];
        }
    }
}

