/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.util.function.Function;
import org.joda.convert.TypedStringConverter;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.MonthDay;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.Period;
import org.threeten.bp.Year;
import org.threeten.bp.YearMonth;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;

enum ThreeTenBpStringConverter implements TypedStringConverter<Object>
{
    INSTANT(Instant.class, Instant::parse),
    DURATION(Duration.class, Duration::parse),
    LOCAL_DATE(LocalDate.class, LocalDate::parse),
    LOCAL_TIME(LocalTime.class, LocalTime::parse),
    LOCAL_DATE_TIME(LocalDateTime.class, LocalDateTime::parse),
    OFFSET_TIME(OffsetTime.class, OffsetTime::parse),
    OFFSET_DATE_TIME(OffsetDateTime.class, OffsetDateTime::parse),
    ZONED_DATE_TIME(ZonedDateTime.class, ZonedDateTime::parse),
    YEAR(Year.class, Year::parse),
    YEAR_MONTH(YearMonth.class, YearMonth::parse),
    MONTH_DAY(MonthDay.class, MonthDay::parse),
    PERIOD(Period.class, Period::parse),
    ZONE_OFFSET(ZoneOffset.class, ZoneOffset::of),
    ZONE_ID(ZoneId.class, ZoneId::of);

    private Class<?> type;
    private Function<String, Object> fromStringFn;

    private ThreeTenBpStringConverter(Class<?> type, Function<String, Object> fromStringFn) {
        this.type = type;
        this.fromStringFn = fromStringFn;
    }

    @Override
    public Class<?> getEffectiveType() {
        return this.type;
    }

    @Override
    public String convertToString(Object object) {
        return object.toString();
    }

    @Override
    public Object convertFromString(Class<? extends Object> cls, String str) {
        return this.fromStringFn.apply(str);
    }
}

