/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Method;
import org.joda.convert.TypedStringConverter;

final class OptionalLongStringConverter
implements TypedStringConverter<Object> {
    private static final Class<?> TYPE;
    private static final Object EMPTY;
    private static final Method METHOD_OF;
    private static final Method METHOD_IS_PRESENT;
    private static final Method METHOD_GET;

    OptionalLongStringConverter() {
    }

    @Override
    public String convertToString(Object object) {
        try {
            Object isPresent = METHOD_IS_PRESENT.invoke(object, new Object[0]);
            return Boolean.TRUE.equals(isPresent) ? String.valueOf(METHOD_GET.invoke(object, new Object[0])) : "";
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Object convertFromString(Class<? extends Object> cls, String str) {
        if ("".equals(str)) {
            return EMPTY;
        }
        long value = Long.parseLong(str);
        try {
            return METHOD_OF.invoke(null, value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Class<?> getEffectiveType() {
        return TYPE;
    }

    static {
        try {
            TYPE = Class.forName("java.util.OptionalLong");
            EMPTY = TYPE.getDeclaredMethod("empty", new Class[0]).invoke(null, new Object[0]);
            METHOD_OF = TYPE.getDeclaredMethod("of", Long.TYPE);
            METHOD_IS_PRESENT = TYPE.getDeclaredMethod("isPresent", new Class[0]);
            METHOD_GET = TYPE.getDeclaredMethod("getAsLong", new Class[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

