/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.spring.autoconfigure;

import java.util.Collections;
import java.util.Optional;
import kotlinx.serialization.json.Json;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.filters.RetryFilter;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.kotlin.utils.mapper.KotlinxSerializationJsonMapper;
import org.jobrunr.scheduling.AsyncJobPostProcessor;
import org.jobrunr.scheduling.JobRequestScheduler;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.scheduling.RecurringJobPostProcessor;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.server.JobActivatorShutdownException;
import org.jobrunr.server.carbonaware.CarbonAwareJobProcessingConfiguration;
import org.jobrunr.server.configuration.BackgroundJobServerThreadType;
import org.jobrunr.server.configuration.BackgroundJobServerWorkerPolicy;
import org.jobrunr.server.configuration.DefaultBackgroundJobServerWorkerPolicy;
import org.jobrunr.spring.autoconfigure.JobRunrProperties;
import org.jobrunr.spring.autoconfigure.JobRunrStarter;
import org.jobrunr.spring.autoconfigure.health.JobRunrHealthIndicator;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.JsonMapperFactory;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={JobRunrProperties.class})
@ComponentScan(basePackages={"org.jobrunr.scheduling"})
public class JobRunrAutoConfiguration {
    @Bean
    public JobRunrStarter jobRunrStarter(Optional<BackgroundJobServer> backgroundJobServer, Optional<JobRunrDashboardWebServer> webServer) {
        return new JobRunrStarter(backgroundJobServer, webServer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="jobrunr.job-scheduler", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public JobScheduler jobScheduler(StorageProvider storageProvider, JobRunrProperties properties) {
        JobDetailsGenerator jobDetailsGenerator = (JobDetailsGenerator)ReflectionUtils.newInstance((String)properties.getJobScheduler().getJobDetailsGenerator(), (Object[])new Object[0]);
        return new JobScheduler(storageProvider, jobDetailsGenerator, Collections.emptyList());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="jobrunr.job-scheduler", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public JobRequestScheduler jobRequestScheduler(StorageProvider storageProvider) {
        return new JobRequestScheduler(storageProvider, Collections.emptyList());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="jobrunr.background-job-server", name={"enabled"}, havingValue="true")
    public BackgroundJobServer backgroundJobServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobActivator jobActivator, BackgroundJobServerConfiguration backgroundJobServerConfiguration, JobRunrProperties properties) {
        BackgroundJobServer backgroundJobServer = new BackgroundJobServer(storageProvider, jobRunrJsonMapper, jobActivator, backgroundJobServerConfiguration);
        backgroundJobServer.setJobFilters(Collections.singletonList(new RetryFilter(properties.getJobs().getDefaultNumberOfRetries(), properties.getJobs().getRetryBackOffTimeSeed())));
        return backgroundJobServer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="jobrunr.background-job-server", name={"enabled"}, havingValue="true")
    public BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy(JobRunrProperties properties) {
        JobRunrProperties.BackgroundJobServer backgroundJobServerProperties = properties.getBackgroundJobServer();
        BackgroundJobServerThreadType threadType = Optional.ofNullable(backgroundJobServerProperties.getThreadType()).orElse(BackgroundJobServerThreadType.getDefaultThreadType());
        int workerCount = Optional.ofNullable(backgroundJobServerProperties.getWorkerCount()).orElse(threadType.getDefaultWorkerCount());
        return new DefaultBackgroundJobServerWorkerPolicy(workerCount, threadType);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="jobrunr.background-job-server", name={"enabled"}, havingValue="true")
    public BackgroundJobServerConfiguration backgroundJobServerConfiguration(JobRunrProperties properties, BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy) {
        PropertyMapper map = PropertyMapper.get();
        BackgroundJobServerConfiguration backgroundJobServerConfiguration = BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration();
        JobRunrProperties.BackgroundJobServer backgroundJobServerProperties = properties.getBackgroundJobServer();
        backgroundJobServerConfiguration.andBackgroundJobServerWorkerPolicy(backgroundJobServerWorkerPolicy);
        map.from(backgroundJobServerProperties::getName).whenNonNull().to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andName(arg_0));
        map.from(backgroundJobServerProperties::getPollIntervalInSeconds).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPollIntervalInSeconds(arg_0));
        map.from(backgroundJobServerProperties::getServerTimeoutPollIntervalMultiplicand).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andServerTimeoutPollIntervalMultiplicand(arg_0));
        map.from(backgroundJobServerProperties::getDeleteSucceededJobsAfter).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andDeleteSucceededJobsAfter(arg_0));
        map.from(backgroundJobServerProperties::getPermanentlyDeleteDeletedJobsAfter).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPermanentlyDeleteDeletedJobsAfter(arg_0));
        map.from(backgroundJobServerProperties::getScheduledJobsRequestSize).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andScheduledJobsRequestSize(arg_0));
        map.from(backgroundJobServerProperties::getCarbonAwaitingJobsRequestSize).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andCarbonAwaitingJobsRequestSize(arg_0));
        map.from(backgroundJobServerProperties::getOrphanedJobsRequestSize).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andOrphanedJobsRequestSize(arg_0));
        map.from(backgroundJobServerProperties::getSucceededJobsRequestSize).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andSucceededJobsRequestSize(arg_0));
        map.from(backgroundJobServerProperties::getInterruptJobsAwaitDurationOnStop).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andInterruptJobsAwaitDurationOnStopBackgroundJobServer(arg_0));
        CarbonAwareJobProcessingConfiguration carbonAwareJobProcessingConfiguration = CarbonAwareJobProcessingConfiguration.usingDisabledCarbonAwareJobProcessingConfiguration();
        JobRunrProperties.CarbonAwareJobProcessing carbonAwareJobProcessingProperties = properties.getBackgroundJobServer().getCarbonAwareJobProcessing();
        map.from(carbonAwareJobProcessingProperties::isEnabled).to(arg_0 -> ((CarbonAwareJobProcessingConfiguration)carbonAwareJobProcessingConfiguration).andCarbonAwareSchedulingEnabled(arg_0));
        map.from(carbonAwareJobProcessingProperties::getDataProvider).whenNonNull().to(arg_0 -> ((CarbonAwareJobProcessingConfiguration)carbonAwareJobProcessingConfiguration).andDataProvider(arg_0));
        map.from(carbonAwareJobProcessingProperties::getAreaCode).whenNonNull().to(arg_0 -> ((CarbonAwareJobProcessingConfiguration)carbonAwareJobProcessingConfiguration).andAreaCode(arg_0));
        map.from(carbonAwareJobProcessingProperties::getExternalCode).whenNonNull().to(arg_0 -> ((CarbonAwareJobProcessingConfiguration)carbonAwareJobProcessingConfiguration).andExternalCode(arg_0));
        map.from(carbonAwareJobProcessingProperties::getExternalIdentifier).whenNonNull().to(arg_0 -> ((CarbonAwareJobProcessingConfiguration)carbonAwareJobProcessingConfiguration).andExternalIdentifier(arg_0));
        map.from(carbonAwareJobProcessingProperties::getApiClientConnectTimeout).whenNonNull().to(arg_0 -> ((CarbonAwareJobProcessingConfiguration)carbonAwareJobProcessingConfiguration).andApiClientConnectTimeout(arg_0));
        map.from(carbonAwareJobProcessingProperties::getApiClientReadTimeout).whenNonNull().to(arg_0 -> ((CarbonAwareJobProcessingConfiguration)carbonAwareJobProcessingConfiguration).andApiClientReadTimeout(arg_0));
        map.from(carbonAwareJobProcessingProperties::getPollIntervalInMinutes).to(arg_0 -> ((CarbonAwareJobProcessingConfiguration)carbonAwareJobProcessingConfiguration).andPollIntervalInMinutes(arg_0));
        backgroundJobServerConfiguration.andCarbonAwareJobProcessingConfiguration(carbonAwareJobProcessingConfiguration);
        return backgroundJobServerConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="jobrunr.dashboard", name={"enabled"}, havingValue="true")
    public JobRunrDashboardWebServer dashboardWebServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration) {
        return new JobRunrDashboardWebServer(storageProvider, jobRunrJsonMapper, dashboardWebServerConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="jobrunr.dashboard", name={"enabled"}, havingValue="true")
    public JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration(JobRunrProperties properties) {
        return JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration().andPort(properties.getDashboard().getPort()).andBasicAuthentication(properties.getDashboard().getUsername(), properties.getDashboard().getPassword()).andAllowAnonymousDataUsage(properties.getMiscellaneous().isAllowAnonymousDataUsage());
    }

    @Bean
    @ConditionalOnMissingBean
    public JobActivator jobActivator(final ApplicationContext applicationContext) {
        return new JobActivator(){
            final /* synthetic */ JobRunrAutoConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            public <T> T activateJob(Class<T> type) throws JobActivatorShutdownException {
                try {
                    return (T)applicationContext.getBean(type);
                }
                catch (BeanCreationNotAllowedException e) {
                    throw new JobActivatorShutdownException("Spring IoC container is shutting down", (Throwable)e);
                }
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMapper jobMapper(JsonMapper jobRunrJsonMapper) {
        return new JobMapper(jobRunrJsonMapper);
    }

    @Bean
    @ConditionalOnBean(value={JobScheduler.class})
    public static RecurringJobPostProcessor recurringJobPostProcessor() {
        return new RecurringJobPostProcessor();
    }

    @Bean
    @ConditionalOnBean(value={JobScheduler.class})
    public static AsyncJobPostProcessor asyncJobPostProcessor() {
        return new AsyncJobPostProcessor();
    }

    @Configuration
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnEnabledHealthIndicator(value="jobrunr")
    public static class JobRunrHealthIndicatorAutoConfiguration {
        @Bean(name={"JobRunr"})
        public HealthIndicator healthIndicator(JobRunrProperties properties, ObjectProvider<BackgroundJobServer> backgroundJobServerProvider) {
            return new JobRunrHealthIndicator(properties, backgroundJobServerProvider);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Json.class, KotlinxSerializationJsonMapper.class})
    public static class JobRunrKotlinxSerializationJsonMapperAutoConfiguration {
        @Bean(name={"jobRunrJsonMapper"})
        @ConditionalOnMissingBean
        public JsonMapper kotlinxSerializationJsonMapper() {
            return new KotlinxSerializationJsonMapper();
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"kotlinx.serialization.json.Json"})
    public static class JobRunrJsonMapperAutoConfiguration
    implements BeanClassLoaderAware {
        public void setBeanClassLoader(ClassLoader classLoader) {
            JsonMapperFactory.setJsonMapperClassPresentFunction(s -> ClassUtils.isPresent((String)s, (ClassLoader)classLoader));
        }

        @Bean(name={"jobRunrJsonMapper"})
        @ConditionalOnMissingBean
        public JsonMapper jobRunrJsonMapper() {
            return JsonMapperFactory.createJsonMapper();
        }
    }
}

