/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.annotations.Job;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.server.runner.ThreadLocalJobContext;
import org.jobrunr.utils.JobUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class AsyncJobInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncJobInterceptor.class);
    private final BeanFactory beanFactory;

    public AsyncJobInterceptor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)invocation.getMethod(), Job.class) || AsyncJobInterceptor.isRunningActualJob(invocation)) {
            return invocation.proceed();
        }
        JobDetails jobDetails = AsyncJobInterceptor.getJobDetails(invocation);
        LOGGER.info("Enqueuing job via @AsyncJob {}", (Object)JobUtils.getJobSignature((JobDetails)jobDetails));
        ((JobScheduler)this.beanFactory.getBean(JobScheduler.class)).enqueue(null, jobDetails);
        return null;
    }

    private static boolean isRunningActualJob(MethodInvocation invocation) {
        JobContext jobContext = ThreadLocalJobContext.getJobContext();
        return jobContext != null && jobContext.getJobSignature().startsWith(invocation.getMethod().getDeclaringClass().getName() + ".");
    }

    private static JobDetails getJobDetails(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        String declaringClassName = method.getDeclaringClass().getName();
        String methodName = method.getName();
        JobDetails jobDetails = new JobDetails(declaringClassName, null, methodName, Stream.of(methodInvocation.getArguments()).map(JobParameter::new).collect(Collectors.toList()));
        jobDetails.setCacheable(true);
        return jobDetails;
    }
}

