/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.aphrodite.antlr;

import java.util.Objects;
import org.jnosql.aphrodite.antlr.DefaultArrayValue;
import org.jnosql.aphrodite.antlr.DefaultFunctionValue;
import org.jnosql.aphrodite.antlr.DefaultJSONValue;
import org.jnosql.aphrodite.antlr.DefaultNumberValue;
import org.jnosql.aphrodite.antlr.DefaultParamValue;
import org.jnosql.aphrodite.antlr.DefaultStringValue;
import org.jnosql.aphrodite.antlr.Elements;
import org.jnosql.aphrodite.antlr.QueryParser;
import org.jnosql.query.QueryException;
import org.jnosql.query.Value;

final class ValueConverter {
    private static final String MESSAGE = "There is an error when trying to convert the value";

    private ValueConverter() {
    }

    static Value<?> get(QueryParser.ValueContext context) {
        if (Objects.nonNull((Object)context.number())) {
            return DefaultNumberValue.of(context.number());
        }
        if (Objects.nonNull((Object)context.string())) {
            return DefaultStringValue.of(context.string());
        }
        if (Objects.nonNull((Object)context.json())) {
            return DefaultJSONValue.of(context.json());
        }
        if (Objects.nonNull((Object)context.parameter())) {
            return DefaultParamValue.of(context.parameter());
        }
        if (Objects.nonNull((Object)context.function())) {
            return DefaultFunctionValue.of(context.function());
        }
        if (Objects.nonNull((Object)context.array())) {
            Value[] elements = (Value[])context.array().element().stream().map(Elements::getElement).toArray(Value[]::new);
            return DefaultArrayValue.of(elements);
        }
        throw new QueryException(MESSAGE);
    }
}

