/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.aphrodite.antlr;

import java.time.Duration;
import java.util.Optional;
import org.jnosql.query.PutQuery;
import org.jnosql.query.Value;

final class DefaultPutQuery
implements PutQuery {
    private final Value<?> key;
    private final Value<?> value;
    private final Duration ttl;

    DefaultPutQuery(Value<?> key, Value<?> value, Duration ttl) {
        this.key = key;
        this.value = value;
        this.ttl = ttl;
    }

    public Value<?> getKey() {
        return this.key;
    }

    public Value<?> getValue() {
        return this.value;
    }

    public Optional<Duration> getTtl() {
        return Optional.ofNullable(this.ttl);
    }

    public String toString() {
        StringBuilder put = new StringBuilder();
        put.append("put {").append(this.key).append(" , ").append(this.value);
        if (this.ttl != null) {
            put.append(",").append(this.ttl);
        }
        put.append("}");
        return put.toString();
    }
}

