/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.aphrodite.antlr;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.query.Condition;
import org.jnosql.query.InsertQuery;

final class DefaultInsertQuery
implements InsertQuery {
    private final String entity;
    private final Duration duration;
    private final List<Condition> conditions;

    DefaultInsertQuery(String entity, Duration duration, List<Condition> conditions) {
        this.entity = entity;
        this.duration = duration;
        this.conditions = conditions;
    }

    public String getEntity() {
        return this.entity;
    }

    public Optional<Duration> getTtl() {
        return Optional.ofNullable(this.duration);
    }

    public List<Condition> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInsertQuery)) {
            return false;
        }
        DefaultInsertQuery that = (DefaultInsertQuery)o;
        return Objects.equals(this.entity, that.entity) && Objects.equals(this.duration, that.duration) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.duration, this.conditions);
    }

    public String toString() {
        return "update " + this.entity + " (" + this.conditions + ") " + this.getTtl().map(Duration::toString).orElse("");
    }
}

