/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.aphrodite.antlr;

import java.util.Objects;
import org.jnosql.aphrodite.antlr.DefaultFunction;
import org.jnosql.aphrodite.antlr.Elements;
import org.jnosql.aphrodite.antlr.QueryParser;
import org.jnosql.query.Function;
import org.jnosql.query.FunctionValue;
import org.jnosql.query.QueryException;
import org.jnosql.query.Value;

final class DefaultFunctionValue
implements FunctionValue {
    private final Function function;

    private DefaultFunctionValue(Function function) {
        this.function = function;
    }

    public Function get() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultFunctionValue)) {
            return false;
        }
        DefaultFunctionValue that = (DefaultFunctionValue)o;
        return Objects.equals(this.function, that.function);
    }

    public int hashCode() {
        return Objects.hashCode(this.function);
    }

    public String toString() {
        return this.function.toString();
    }

    static FunctionValue of(QueryParser.FunctionContext context) {
        if (Objects.nonNull((Object)context.convert())) {
            return DefaultFunctionValue.getConverter(context);
        }
        throw new UnsupportedOperationException("There is not support to this function yet");
    }

    private static FunctionValue getConverter(QueryParser.FunctionContext context) {
        QueryParser.ConvertContext converter = context.convert();
        Value<?> value = Elements.getElement(converter.element());
        String text = converter.name().getText();
        try {
            Object[] params = new Object[]{value, Class.forName(text)};
            Function function1 = DefaultFunction.of("convert", params);
            return new DefaultFunctionValue(function1);
        }
        catch (ClassNotFoundException e) {
            throw new QueryException("Class does not found the converter function argument: " + text, (Throwable)e);
        }
    }
}

