/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonObject;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.document.query.JsonObjects;
import org.jnosql.diana.api.document.query.Params;
import org.jnosql.query.ArrayValue;
import org.jnosql.query.Function;
import org.jnosql.query.FunctionValue;
import org.jnosql.query.JSONValue;
import org.jnosql.query.ParamValue;
import org.jnosql.query.QueryException;
import org.jnosql.query.ValueType;

final class Values {
    private Values() {
    }

    static Object get(org.jnosql.query.Value<?> value, Params parameters) {
        ValueType type = value.getType();
        switch (type) {
            case NUMBER: 
            case STRING: {
                return value.get();
            }
            case PARAMETER: {
                return parameters.add((String)((ParamValue)ParamValue.class.cast(value)).get());
            }
            case ARRAY: {
                return Stream.of((Object[])((ArrayValue)ArrayValue.class.cast(value)).get()).map(v -> Values.get(v, parameters)).collect(Collectors.toList());
            }
            case FUNCTION: {
                Function function = (Function)((FunctionValue)FunctionValue.class.cast(value)).get();
                String name = function.getName();
                Object[] params = function.getParams();
                if ("convert".equals(name)) {
                    return Value.of((Object)Values.get((org.jnosql.query.Value)org.jnosql.query.Value.class.cast(params[0]), parameters)).get((Class)params[1]);
                }
                String message = String.format("There is not support to the fuction: %s with parameters %s", name, Arrays.toString(params));
                throw new QueryException(message);
            }
            case JSON: {
                return JsonObjects.getDocuments((JsonObject)((JSONValue)JSONValue.class.cast(value)).get());
            }
        }
        throw new QueryException("There is not suppor to the value: " + type);
    }
}

