/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentPreparedStatement;
import org.jnosql.diana.api.document.DocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.query.Conditions;
import org.jnosql.diana.api.document.query.DefaultDocumentPreparedStatement;
import org.jnosql.diana.api.document.query.DefaultDocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.query.Params;
import org.jnosql.query.InsertQuery;
import org.jnosql.query.InsertQuerySupplier;
import org.jnosql.query.QueryException;

final class InsertQueryParser {
    private final InsertQuerySupplier supplier = InsertQuerySupplier.getSupplier();

    InsertQueryParser() {
    }

    List<DocumentEntity> query(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.supplier.apply((Object)query);
        String collection = insertQuery.getEntity();
        Params params = new Params();
        DocumentEntity entity = this.getEntity(insertQuery, collection, params, observer);
        Optional ttl = insertQuery.getTtl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        if (ttl.isPresent()) {
            return Collections.singletonList(collectionManager.insert(entity, (Duration)ttl.get()));
        }
        return Collections.singletonList(collectionManager.insert(entity));
    }

    void queryAsync(String query, DocumentCollectionManagerAsync collectionManager, Consumer<List<DocumentEntity>> callBack, DocumentObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.supplier.apply((Object)query);
        String collection = observer.fireEntity(insertQuery.getEntity());
        Params params = new Params();
        DocumentEntity entity = this.getEntity(insertQuery, collection, params, observer);
        Optional ttl = insertQuery.getTtl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        if (ttl.isPresent()) {
            collectionManager.insert(entity, (Duration)ttl.get(), c -> callBack.accept(Collections.singletonList(c)));
        } else {
            collectionManager.insert(entity, c -> callBack.accept(Collections.singletonList(c)));
        }
    }

    DocumentPreparedStatement prepare(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.supplier.apply((Object)query);
        String collection = observer.fireEntity(insertQuery.getEntity());
        Params params = new Params();
        Optional ttl = insertQuery.getTtl();
        DocumentEntity entity = this.getEntity(insertQuery, collection, params, observer);
        return DefaultDocumentPreparedStatement.insert(entity, params, query, ttl.orElse(null), collectionManager);
    }

    DocumentPreparedStatementAsync prepareAsync(String query, DocumentCollectionManagerAsync collectionManager, DocumentObserverParser observer) {
        Params params = new Params();
        InsertQuery insertQuery = (InsertQuery)this.supplier.apply((Object)query);
        String collection = observer.fireEntity(insertQuery.getEntity());
        Optional ttl = insertQuery.getTtl();
        DocumentEntity entity = this.getEntity(insertQuery, collection, params, observer);
        return DefaultDocumentPreparedStatementAsync.insert(entity, params, query, ttl.orElse(null), collectionManager);
    }

    private DocumentEntity getEntity(InsertQuery insertQuery, String collection, Params params, DocumentObserverParser observer) {
        DocumentEntity entity = DocumentEntity.of(collection);
        insertQuery.getConditions().stream().map(c -> Conditions.getCondition(c, params, observer, collection)).map(DocumentCondition::getDocument).forEach(entity::add);
        return entity;
    }
}

