/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentPreparedStatement;
import org.jnosql.diana.api.document.DocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.query.CacheQuery;
import org.jnosql.diana.api.document.query.Conditions;
import org.jnosql.diana.api.document.query.DefaultDocumentDeleteQuery;
import org.jnosql.diana.api.document.query.DefaultDocumentPreparedStatement;
import org.jnosql.diana.api.document.query.DefaultDocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.query.Params;
import org.jnosql.query.DeleteQuery;
import org.jnosql.query.DeleteQuerySupplier;
import org.jnosql.query.QueryException;

final class DeleteQueryParser {
    private final DeleteQuerySupplier selectQuerySupplier = DeleteQuerySupplier.getSupplier();
    private final CacheQuery<DocumentDeleteQuery> cache = new CacheQuery<DocumentDeleteQuery>(this::getQuery);

    DeleteQueryParser() {
    }

    List<DocumentEntity> query(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        DocumentDeleteQuery documentQuery = this.cache.get(query, observer);
        collectionManager.delete(documentQuery);
        return Collections.emptyList();
    }

    void queryAsync(String query, DocumentCollectionManagerAsync collectionManager, Consumer<List<DocumentEntity>> callBack, DocumentObserverParser observer) {
        DocumentDeleteQuery documentQuery = this.cache.get(query, observer);
        collectionManager.delete(documentQuery, v -> callBack.accept(Collections.emptyList()));
    }

    DocumentPreparedStatement prepare(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        Params params = new Params();
        DocumentDeleteQuery documentQuery = this.getQuery(query, params, observer);
        return DefaultDocumentPreparedStatement.delete(documentQuery, params, query, collectionManager);
    }

    DocumentPreparedStatementAsync prepareAsync(String query, DocumentCollectionManagerAsync collectionManager, DocumentObserverParser observer) {
        Params params = new Params();
        DocumentDeleteQuery documentQuery = this.getQuery(query, params, observer);
        return DefaultDocumentPreparedStatementAsync.delete(documentQuery, params, query, collectionManager);
    }

    private DocumentDeleteQuery getQuery(String query, Params params, DocumentObserverParser observer) {
        DeleteQuery deleteQuery = (DeleteQuery)this.selectQuerySupplier.apply((Object)query);
        String collection = observer.fireEntity(deleteQuery.getEntity());
        List<String> documents = deleteQuery.getFields().stream().map(f -> observer.fireField(collection, (String)f)).collect(Collectors.toList());
        DocumentCondition condition = null;
        if (deleteQuery.getWhere().isPresent()) {
            condition = deleteQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, collection)).get();
        }
        return new DefaultDocumentDeleteQuery(collection, condition, documents);
    }

    private DocumentDeleteQuery getQuery(String query, DocumentObserverParser observer) {
        DeleteQuery deleteQuery = (DeleteQuery)this.selectQuerySupplier.apply((Object)query);
        String collection = observer.fireEntity(deleteQuery.getEntity());
        List<String> documents = deleteQuery.getFields().stream().map(f -> observer.fireField(collection, (String)f)).collect(Collectors.toList());
        DocumentCondition condition = null;
        Params params = new Params();
        if (deleteQuery.getWhere().isPresent()) {
            condition = deleteQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, collection)).get();
        }
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultDocumentDeleteQuery(collection, condition, documents);
    }
}

