/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.BaseQueryBuilder;
import org.jnosql.diana.api.document.query.DefaultDocumentQuery;
import org.jnosql.diana.api.document.query.DocumentFrom;
import org.jnosql.diana.api.document.query.DocumentLimit;
import org.jnosql.diana.api.document.query.DocumentNameCondition;
import org.jnosql.diana.api.document.query.DocumentNameOrder;
import org.jnosql.diana.api.document.query.DocumentNotCondition;
import org.jnosql.diana.api.document.query.DocumentOrder;
import org.jnosql.diana.api.document.query.DocumentSelect;
import org.jnosql.diana.api.document.query.DocumentSkip;
import org.jnosql.diana.api.document.query.DocumentWhere;

class DefaultSelectQueryBuilder
extends BaseQueryBuilder
implements DocumentSelect,
DocumentFrom,
DocumentLimit,
DocumentSkip,
DocumentOrder,
DocumentNotCondition,
DocumentNameOrder,
DocumentWhere {
    private String documentCollection;
    private long skip;
    private long limit;
    private final List<Sort> sorts = new ArrayList<Sort>();
    private final List<String> documents;

    DefaultSelectQueryBuilder(List<String> documents) {
        this.documents = documents;
    }

    @Override
    public DocumentFrom from(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        this.documentCollection = documentCollection;
        return this;
    }

    @Override
    public DocumentNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public DocumentNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    @Override
    public DocumentNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    @Override
    public DocumentSkip skip(long skip) {
        this.skip = skip;
        return this;
    }

    @Override
    public DocumentLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public DocumentOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public DocumentNotCondition not() {
        this.negate = true;
        return this;
    }

    @Override
    public <T> DocumentWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    @Override
    public DocumentWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    @Override
    public <T> DocumentWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    @Override
    public <T> DocumentWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    @Override
    public <T> DocumentWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    @Override
    public <T> DocumentWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    @Override
    public <T> DocumentWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    @Override
    public <T> DocumentWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    @Override
    public DocumentNameOrder asc() {
        this.sorts.add(Sort.of((String)this.name, (Sort.SortType)Sort.SortType.ASC));
        return this;
    }

    @Override
    public DocumentNameOrder desc() {
        this.sorts.add(Sort.of((String)this.name, (Sort.SortType)Sort.SortType.DESC));
        return this;
    }

    @Override
    public DocumentQuery build() {
        return new DefaultDocumentQuery(this.limit, this.skip, this.documentCollection, this.documents, this.sorts, this.condition);
    }
}

