/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.DocumentQueryParserAsync;
import org.jnosql.diana.api.document.query.DeleteQueryParser;
import org.jnosql.diana.api.document.query.InsertQueryParser;
import org.jnosql.diana.api.document.query.SelectQueryParser;
import org.jnosql.diana.api.document.query.UpdateQueryParser;
import org.jnosql.query.QueryException;

public final class DefaultDocumentQueryParserAsync
implements DocumentQueryParserAsync {
    private final SelectQueryParser select = new SelectQueryParser();
    private final DeleteQueryParser delete = new DeleteQueryParser();
    private final InsertQueryParser insert = new InsertQueryParser();
    private final UpdateQueryParser update = new UpdateQueryParser();

    @Override
    public void query(String query, DocumentCollectionManagerAsync collectionManager, Consumer<List<DocumentEntity>> callBack, DocumentObserverParser observer) {
        String command;
        this.validation(query, collectionManager, callBack, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                this.select.queryAsync(query, collectionManager, callBack, observer);
                return;
            }
            case "delete": {
                this.delete.queryAsync(query, collectionManager, callBack, observer);
                return;
            }
            case "insert": {
                this.insert.queryAsync(query, collectionManager, callBack, observer);
                return;
            }
            case "update": {
                this.update.queryAsync(query, collectionManager, callBack, observer);
                return;
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    @Override
    public DocumentPreparedStatementAsync prepare(String query, DocumentCollectionManagerAsync collectionManager, DocumentObserverParser observer) {
        String command;
        this.validation(query, collectionManager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.prepareAsync(query, collectionManager, observer);
            }
            case "delete": {
                return this.delete.prepareAsync(query, collectionManager, observer);
            }
            case "insert": {
                return this.insert.prepareAsync(query, collectionManager, observer);
            }
            case "update": {
                return this.update.prepareAsync(query, collectionManager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    private void validation(String query, DocumentCollectionManagerAsync collectionManager, DocumentObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(observer, "observer is required");
        Objects.requireNonNull(collectionManager, "collectionManager is required");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }

    private void validation(String query, DocumentCollectionManagerAsync collectionManager, Consumer<List<DocumentEntity>> callBack, DocumentObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(collectionManager, "collectionManager is required");
        Objects.requireNonNull(callBack, "callBack is required");
        Objects.requireNonNull(observer, "observer is required");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

