/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.List;
import java.util.Objects;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentPreparedStatement;
import org.jnosql.diana.api.document.DocumentQueryParser;
import org.jnosql.diana.api.document.query.DeleteQueryParser;
import org.jnosql.diana.api.document.query.InsertQueryParser;
import org.jnosql.diana.api.document.query.SelectQueryParser;
import org.jnosql.diana.api.document.query.UpdateQueryParser;
import org.jnosql.query.QueryException;

public final class DefaultDocumentQueryParser
implements DocumentQueryParser {
    private final SelectQueryParser select = new SelectQueryParser();
    private final DeleteQueryParser delete = new DeleteQueryParser();
    private final InsertQueryParser insert = new InsertQueryParser();
    private final UpdateQueryParser update = new UpdateQueryParser();

    @Override
    public List<DocumentEntity> query(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        String command;
        this.validation(query, collectionManager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.query(query, collectionManager, observer);
            }
            case "delete": {
                return this.delete.query(query, collectionManager, observer);
            }
            case "insert": {
                return this.insert.query(query, collectionManager, observer);
            }
            case "update": {
                return this.update.query(query, collectionManager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    @Override
    public DocumentPreparedStatement prepare(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        String command;
        this.validation(query, collectionManager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.prepare(query, collectionManager, observer);
            }
            case "delete": {
                return this.delete.prepare(query, collectionManager, observer);
            }
            case "insert": {
                return this.insert.prepare(query, collectionManager, observer);
            }
            case "update": {
                return this.update.prepare(query, collectionManager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    private void validation(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(collectionManager, "collectionManager is required");
        Objects.requireNonNull(observer, "observer is required");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

