/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document;

import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.document.DocumentQueryParser;

final class DocumentQueryParserServiceLoader {
    private static final List<DocumentQueryParser> LOADERS;
    static final Optional<DocumentQueryParser> INSTANCE;
    private static final String MESSAGE = "Could not found an implementation of DocumentQueryParser in service loader.";

    private DocumentQueryParserServiceLoader() {
    }

    static DocumentQueryParser getInstance() {
        return INSTANCE.orElseThrow(() -> new IllegalStateException(MESSAGE));
    }

    static {
        ServiceLoader<DocumentQueryParser> serviceLoader = ServiceLoader.load(DocumentQueryParser.class);
        LOADERS = StreamSupport.stream(serviceLoader.spliterator(), false).collect(Collectors.toList());
        INSTANCE = LOADERS.stream().findFirst();
    }
}

