/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentEntity;

final class DefaultDocumentEntity
implements DocumentEntity {
    private final Map<String, Document> documents = new HashMap<String, Document>();
    private final String name;

    DefaultDocumentEntity(String name) {
        this.name = Objects.requireNonNull(name, "name name is required");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean remove(String documentName) {
        Objects.requireNonNull(documentName, "documentName is required");
        return this.documents.remove(documentName) != null;
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public void add(Document document) {
        Objects.requireNonNull(document, "Document is required");
        this.documents.put(document.getName(), document);
    }

    @Override
    public void add(String documentName, Object value) {
        Objects.requireNonNull(documentName, "documentName is required");
        Objects.requireNonNull(value, "value is required");
        this.add(Document.of(documentName, value));
    }

    @Override
    public void add(String documentName, Value value) {
        Objects.requireNonNull(documentName, "documentName is required");
        Objects.requireNonNull(value, "value is required");
        this.remove(documentName);
        this.add(Document.of(documentName, value));
    }

    @Override
    public void addAll(Iterable<Document> documents) {
        Objects.requireNonNull(documents, "documents are required");
        documents.forEach(this::add);
    }

    @Override
    public Optional<Document> find(String documentName) {
        Objects.requireNonNull(documentName, "documentName is required");
        Document document = this.documents.get(documentName);
        return Optional.ofNullable(document);
    }

    @Override
    public int size() {
        return this.documents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.documents.isEmpty();
    }

    @Override
    public DocumentEntity copy() {
        DefaultDocumentEntity entity = new DefaultDocumentEntity(this.name);
        entity.documents.putAll(new HashMap<String, Document>(this.documents));
        return entity;
    }

    @Override
    public void clear() {
        this.documents.clear();
    }

    @Override
    public Set<String> getDocumentNames() {
        return Collections.unmodifiableSet(this.documents.keySet());
    }

    @Override
    public Collection<Value> getValues() {
        return this.documents.values().stream().map(Document::getValue).collect(Collectors.toList());
    }

    @Override
    public boolean contains(String documentName) {
        Objects.requireNonNull(documentName, "documentName is required");
        return this.documents.containsKey(documentName);
    }

    @Override
    public Map<String, Object> toMap() {
        return this.documents.entrySet().stream().collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, e -> ((Document)e.getValue()).get()), Collections::unmodifiableMap));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentEntity)) {
            return false;
        }
        DocumentEntity that = (DocumentEntity)o;
        return Objects.equals(this.getDocuments().stream().sorted(Comparator.comparing(Document::getName)).collect(Collectors.toList()), that.getDocuments().stream().sorted(Comparator.comparing(Document::getName)).collect(Collectors.toList())) && Objects.equals(this.name, that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.documents, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDocumentEntity{");
        sb.append("documents=").append(this.toMap());
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

