/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.spi;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducer;
import org.jnosql.artemis.DatabaseMetadata;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.Databases;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.query.DocumentRepositoryAsyncBean;
import org.jnosql.artemis.document.query.RepositoryDocumentBean;
import org.jnosql.artemis.document.spi.DocumentTemplateAsyncBean;
import org.jnosql.artemis.document.spi.DocumentTemplateBean;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;

public class DocumentCollectionProducerExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(DocumentCollectionProducerExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();
    private final Set<DatabaseMetadata> databasesAsync = new HashSet<DatabaseMetadata>();
    private final Collection<Class<?>> crudTypes = new HashSet();
    private final Collection<Class<?>> crudAsyncTypes = new HashSet();

    <T extends Repository> void onProcessAnnotatedType(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (Repository.class.equals((Object)javaClass)) {
            return;
        }
        if (Stream.of(javaClass.getInterfaces()).anyMatch(Repository.class::equals) && Modifier.isInterface(javaClass.getModifiers())) {
            LOGGER.info("Adding a new Repository as discovered on document: " + javaClass);
            this.crudTypes.add(javaClass);
        }
    }

    <T extends RepositoryAsync> void onProcessAnnotatedTypeAsync(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (RepositoryAsync.class.equals((Object)javaClass)) {
            return;
        }
        if (Stream.of(javaClass.getInterfaces()).anyMatch(RepositoryAsync.class::equals) && Modifier.isInterface(javaClass.getModifiers())) {
            LOGGER.info("Adding a new RepositoryAsync as discovered on document: " + javaClass);
            this.crudAsyncTypes.add(javaClass);
        }
    }

    <T, X extends DocumentCollectionManager> void processProducer(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.DOCUMENT, this.databases);
    }

    <T, X extends DocumentCollectionManagerAsync> void processProducerAsync(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.DOCUMENT, this.databasesAsync);
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        LOGGER.info(String.format("Starting to process on documents: %d databases crud %d and crudAsync %d", this.databases.size(), this.crudTypes.size(), this.crudAsyncTypes.size()));
        this.databases.forEach(type -> {
            DocumentTemplateBean bean = new DocumentTemplateBean(beanManager, type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        this.databasesAsync.forEach(type -> {
            DocumentTemplateAsyncBean bean = new DocumentTemplateAsyncBean(beanManager, type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        this.crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_DOCUMENT)) {
                afterBeanDiscovery.addBean((Bean)new RepositoryDocumentBean((Class)type, beanManager, ""));
            }
            this.databases.forEach(database -> {
                RepositoryDocumentBean bean = new RepositoryDocumentBean((Class)type, beanManager, database.getProvider());
                afterBeanDiscovery.addBean((Bean)bean);
            });
        });
        this.crudAsyncTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_DOCUMENT)) {
                afterBeanDiscovery.addBean((Bean)new DocumentRepositoryAsyncBean((Class)type, beanManager, ""));
            }
            this.databasesAsync.forEach(database -> {
                DocumentRepositoryAsyncBean bean = new DocumentRepositoryAsyncBean((Class)type, beanManager, database.getProvider());
                afterBeanDiscovery.addBean((Bean)bean);
            });
        });
    }
}

