/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.document.DocumentQuery;

final class ReturnTypeConverterUtil {
    private ReturnTypeConverterUtil() {
    }

    static Object returnObject(DocumentQuery query, DocumentTemplate repository, Class typeClass, Method method) {
        Class<?> returnType = method.getReturnType();
        if (typeClass.equals(returnType)) {
            Optional<Object> optional = repository.singleResult(query);
            return optional.orElse(null);
        }
        if (Optional.class.equals(returnType)) {
            return repository.singleResult(query);
        }
        if (List.class.equals(returnType) || Iterable.class.equals(returnType) || Collection.class.equals(returnType)) {
            return repository.select(query);
        }
        if (Set.class.equals(returnType)) {
            return new HashSet(repository.select(query));
        }
        if (Queue.class.equals(returnType)) {
            return new PriorityQueue(repository.select(query));
        }
        if (Stream.class.equals(returnType)) {
            return repository.select(query).stream();
        }
        return repository.select(query);
    }

    static <T> Object returnObject(List<T> entities, Class<?> typeClass, Method method) {
        Class<?> returnType = method.getReturnType();
        if (typeClass.equals(returnType)) {
            return ReturnTypeConverterUtil.getObject(entities, method);
        }
        if (Optional.class.equals(returnType)) {
            return Optional.ofNullable(ReturnTypeConverterUtil.getObject(entities, method));
        }
        if (List.class.equals(returnType) || Iterable.class.equals(returnType) || Collection.class.equals(returnType)) {
            return entities;
        }
        if (Set.class.equals(returnType)) {
            return new HashSet<T>(entities);
        }
        if (Queue.class.equals(returnType)) {
            return new PriorityQueue<T>(entities);
        }
        if (Stream.class.equals(returnType)) {
            return entities.stream();
        }
        return entities;
    }

    private static <T> Object getObject(List<T> entities, Method method) {
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() == 1) {
            return entities.get(0);
        }
        throw new NonUniqueResultException("No unique result to the method: " + method);
    }
}

