/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.Arrays;
import java.util.stream.Stream;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.DynamicQueryException;
import org.jnosql.artemis.document.query.DocumentTokenProcessor;
import org.jnosql.artemis.document.util.ConverterUtil;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCondition;

enum DocumentTokenProcessorType implements DocumentTokenProcessor
{
    BETWEEN("Between", 2){

        @Override
        public DocumentCondition process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, Converters converters) {
            DocumentTokenProcessorType.checkContents(index, args.length, this.getFieldsRequired(), methodName);
            String name = DocumentTokenProcessorType.getName(token, representation).replace(this.getType(), "");
            Object valueA = DocumentTokenProcessorType.getValue(token, args[index], representation, converters);
            Object valueB = DocumentTokenProcessorType.getValue(token, args[++index], representation, converters);
            return DocumentCondition.between((Document)Document.of((String)name, Arrays.asList(valueA, valueB)));
        }
    }
    ,
    LESS_THAN_EQUAL("LessThanEqual", 1){

        @Override
        public DocumentCondition process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, Converters converters) {
            DocumentTokenProcessorType.checkContents(index, args.length, this.getFieldsRequired(), methodName);
            String name = DocumentTokenProcessorType.getName(token, representation).replace(this.getType(), "");
            Object value = DocumentTokenProcessorType.getValue(token, args[index], representation, converters);
            return DocumentCondition.lte((Document)Document.of((String)name, (Object)value));
        }
    }
    ,
    GREATER_THAN_EQUAL("GreaterThanEqual", 1){

        @Override
        public DocumentCondition process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, Converters converters) {
            DocumentTokenProcessorType.checkContents(index, args.length, this.getFieldsRequired(), methodName);
            String name = DocumentTokenProcessorType.getName(token, representation).replace(this.getType(), "");
            Object value = DocumentTokenProcessorType.getValue(token, args[index], representation, converters);
            return DocumentCondition.gte((Document)Document.of((String)name, (Object)value));
        }
    }
    ,
    LESS_THAN("LessThan", 1){

        @Override
        public DocumentCondition process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, Converters converters) {
            DocumentTokenProcessorType.checkContents(index, args.length, this.getFieldsRequired(), methodName);
            String name = DocumentTokenProcessorType.getName(token, representation).replace(this.getType(), "");
            Object value = DocumentTokenProcessorType.getValue(token, args[index], representation, converters);
            return DocumentCondition.lt((Document)Document.of((String)name, (Object)value));
        }
    }
    ,
    GREATER_THAN("GreaterThan", 1){

        @Override
        public DocumentCondition process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, Converters converters) {
            DocumentTokenProcessorType.checkContents(index, args.length, this.getFieldsRequired(), methodName);
            String name = DocumentTokenProcessorType.getName(token, representation).replace(this.getType(), "");
            Object value = DocumentTokenProcessorType.getValue(token, args[index], representation, converters);
            return DocumentCondition.gt((Document)Document.of((String)name, (Object)value));
        }
    }
    ,
    LIKE("Like", 1){

        @Override
        public DocumentCondition process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, Converters converters) {
            DocumentTokenProcessorType.checkContents(index, args.length, this.getFieldsRequired(), methodName);
            String name = DocumentTokenProcessorType.getName(token, representation).replace(this.getType(), "");
            Object value = DocumentTokenProcessorType.getValue(token, args[index], representation, converters);
            return DocumentCondition.like((Document)Document.of((String)name, (Object)value));
        }
    }
    ,
    DEFAULT("", 1){

        @Override
        public DocumentCondition process(String token, int index, Object[] args, String methodName, ClassRepresentation representation, Converters converters) {
            DocumentTokenProcessorType.checkContents(index, args.length, this.getFieldsRequired(), methodName);
            String name = DocumentTokenProcessorType.getName(token, representation);
            Object value = DocumentTokenProcessorType.getValue(token, args[index], representation, converters);
            return DocumentCondition.eq((Document)Document.of((String)name, (Object)value));
        }
    };

    private final String type;
    private final int fieldsRequired;

    private DocumentTokenProcessorType(String type, int fieldsRequired) {
        this.type = type;
        this.fieldsRequired = fieldsRequired;
    }

    public String getType() {
        return this.type;
    }

    public int getFieldsRequired() {
        return this.fieldsRequired;
    }

    private static void checkContents(int index, int argSize, int required, String method) {
        if (index + required <= argSize) {
            return;
        }
        throw new DynamicQueryException(String.format("There is a missed argument in the method %s", method));
    }

    private static String getName(String token, ClassRepresentation representation) {
        return representation.getColumnField(DocumentTokenProcessorType.getJavaField(token));
    }

    private static Object getValue(String token, Object value, ClassRepresentation representation, Converters converters) {
        String javaField = DocumentTokenProcessorType.getJavaField(token);
        return ConverterUtil.getValue(value, representation, javaField, converters);
    }

    private static String getJavaField(String token) {
        return String.valueOf(Character.toLowerCase(token.charAt(0))).concat(token.substring(1));
    }

    static DocumentTokenProcessorType of(String token) {
        return Stream.of(DocumentTokenProcessorType.values()).filter(t -> token.contains(t.getType())).findFirst().orElse(DEFAULT);
    }
}

