/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jnosql.artemis.Query;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentQuery;

enum DocumentRepositoryType {
    DEFAULT,
    FIND_BY,
    FIND_ALL,
    DELETE_BY,
    QUERY,
    QUERY_DELETE,
    UNKNOWN,
    OBJECT_METHOD,
    JNOSQL_QUERY;

    private static final Method[] METHODS;

    static DocumentRepositoryType of(Method method, Object[] args) {
        String methodName;
        if (Stream.of(METHODS).anyMatch(method::equals)) {
            return OBJECT_METHOD;
        }
        if (Objects.nonNull(method.getAnnotation(Query.class))) {
            return JNOSQL_QUERY;
        }
        switch (methodName = method.getName()) {
            case "save": 
            case "deleteById": 
            case "delete": 
            case "findById": 
            case "existsById": {
                return DEFAULT;
            }
            case "findAll": {
                return FIND_ALL;
            }
        }
        if (DocumentRepositoryType.isQuery(args)) {
            return QUERY;
        }
        if (DocumentRepositoryType.isQueryDelete(args)) {
            return QUERY_DELETE;
        }
        if (methodName.startsWith("findBy")) {
            return FIND_BY;
        }
        if (methodName.startsWith("deleteBy")) {
            return DELETE_BY;
        }
        return UNKNOWN;
    }

    private static boolean isQuery(Object[] args) {
        return DocumentRepositoryType.getQuery(args).isPresent();
    }

    private static boolean isQueryDelete(Object[] args) {
        return DocumentRepositoryType.getDeleteQuery(args).isPresent();
    }

    static Optional<DocumentQuery> getQuery(Object[] args) {
        return Stream.of(args).filter(DocumentQuery.class::isInstance).map(DocumentQuery.class::cast).findFirst();
    }

    static Optional<DocumentDeleteQuery> getDeleteQuery(Object[] args) {
        return Stream.of(args).filter(DocumentDeleteQuery.class::isInstance).map(DocumentDeleteQuery.class::cast).findFirst();
    }

    static {
        METHODS = Object.class.getMethods();
    }
}

