/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.ParameterizedType;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.query.AbstractDocumentRepositoryAsync;
import org.jnosql.artemis.document.query.AbstractDocumentRepositoryAsyncProxy;
import org.jnosql.artemis.document.query.DocumentQueryDeleteParser;
import org.jnosql.artemis.document.query.DocumentQueryParser;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;

class DocumentRepositoryAsyncProxy<T>
extends AbstractDocumentRepositoryAsyncProxy {
    private final DocumentTemplateAsync template;
    private final DocumentRepositoryAsync repository;
    private final ClassRepresentation classRepresentation;
    private final DocumentQueryParser queryParser;
    private final DocumentQueryDeleteParser deleteParser;
    private final Converters converters;

    DocumentRepositoryAsyncProxy(DocumentTemplateAsync template, ClassRepresentations classRepresentations, Class<?> repositoryType, Reflections reflections, Converters converters) {
        this.template = template;
        Class typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(repositoryType.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.classRepresentation = classRepresentations.get(typeClass);
        this.repository = new DocumentRepositoryAsync(template, this.classRepresentation, reflections);
        this.queryParser = new DocumentQueryParser();
        this.deleteParser = new DocumentQueryDeleteParser();
        this.converters = converters;
    }

    @Override
    protected RepositoryAsync getRepository() {
        return this.repository;
    }

    @Override
    protected DocumentQueryParser getQueryParser() {
        return this.queryParser;
    }

    @Override
    protected DocumentTemplateAsync getTemplate() {
        return this.template;
    }

    @Override
    protected DocumentQueryDeleteParser getDeleteParser() {
        return this.deleteParser;
    }

    @Override
    protected ClassRepresentation getClassRepresentation() {
        return this.classRepresentation;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }

    class DocumentRepositoryAsync
    extends AbstractDocumentRepositoryAsync
    implements RepositoryAsync {
        private final DocumentTemplateAsync template;
        private final ClassRepresentation classRepresentation;
        private final Reflections reflections;

        DocumentRepositoryAsync(DocumentTemplateAsync template, ClassRepresentation classRepresentation, Reflections reflections) {
            this.template = template;
            this.classRepresentation = classRepresentation;
            this.reflections = reflections;
        }

        @Override
        protected DocumentTemplateAsync getTemplate() {
            return this.template;
        }

        @Override
        protected Reflections getReflections() {
            return this.reflections;
        }

        @Override
        protected ClassRepresentation getClassRepresentation() {
            return this.classRepresentation;
        }
    }
}

