/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.Pagination;
import org.jnosql.artemis.document.query.ArtemisDocumentQuery;
import org.jnosql.artemis.document.query.DocumentQueryParserUtil;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentQuery;

public class DocumentQueryParser {
    private static final Logger LOGGER = Logger.getLogger(DocumentQueryParser.class.getName());
    private static final String PREFIX = "findBy";
    private static final String TOKENIZER = "(?=And|OrderBy|Or)";

    public DocumentQuery parse(String methodName, Object[] args, ClassRepresentation representation, Converters converters) {
        String[] tokens = methodName.replace(PREFIX, "").split(TOKENIZER);
        String className = representation.getClassInstance().getName();
        DocumentCondition condition = null;
        ArrayList<Sort> sorts = new ArrayList<Sort>();
        long limit = 0L;
        long start = 0L;
        int index = 0;
        for (String token : tokens) {
            DocumentQueryParserUtil.ConditionResult result;
            if (token.startsWith("And")) {
                result = DocumentQueryParserUtil.and(args, index, token, methodName, representation, condition, converters);
                condition = result.getCondition();
                index = result.getIndex();
                continue;
            }
            if (token.startsWith("OrderBy")) {
                this.sort(sorts, token, representation);
                continue;
            }
            if (token.startsWith("Or")) {
                result = DocumentQueryParserUtil.or(args, index, token, methodName, representation, condition, converters);
                condition = result.getCondition();
                index = result.getIndex();
                continue;
            }
            condition = DocumentQueryParserUtil.toCondition(token, index, args, methodName, representation, converters);
            ++index;
        }
        while (index < args.length) {
            Object value = args[index];
            if (Sort.class.isInstance(value)) {
                sorts.add((Sort)Sort.class.cast(value));
            } else if (Pagination.class.isInstance(value)) {
                Pagination pagination = (Pagination)Pagination.class.cast(value);
                limit = pagination.getLimit();
                start = pagination.getSkip();
            } else {
                LOGGER.info(String.format("Ignoring parameter %s on  methodName %s class name %s arg-number: %d", String.valueOf(value), methodName, className, index));
            }
            ++index;
        }
        return new ArtemisDocumentQuery(sorts, limit, start, condition, representation.getName());
    }

    private void sort(List<Sort> sorts, String token, ClassRepresentation representation) {
        String field = token.replace("OrderBy", "");
        if (field.contains("Desc")) {
            sorts.add(Sort.of((String)this.getName(field.replace("Desc", ""), representation), (Sort.SortType)Sort.SortType.DESC));
        } else {
            sorts.add(Sort.of((String)this.getName(field.replace("Asc", ""), representation), (Sort.SortType)Sort.SortType.ASC));
        }
    }

    private String getName(String token, ClassRepresentation representation) {
        return representation.getColumnField(String.valueOf(Character.toLowerCase(token.charAt(0))).concat(token.substring(1)));
    }
}

