/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.query.ArtemisDocumentDeleteQuery;
import org.jnosql.artemis.document.query.DocumentQueryParserUtil;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentDeleteQuery;

public class DocumentQueryDeleteParser {
    private static final String PREFIX = "deleteBy";
    private static final String TOKENIZER = "(?=And|OrderBy|Or)";

    public DocumentDeleteQuery parse(String methodName, Object[] args, ClassRepresentation representation, Converters converters) {
        String[] tokens = methodName.replace(PREFIX, "").split(TOKENIZER);
        DocumentCondition condition = null;
        int index = 0;
        for (String token : tokens) {
            DocumentQueryParserUtil.ConditionResult result;
            if (token.startsWith("And")) {
                result = DocumentQueryParserUtil.and(args, index, token, methodName, representation, condition, converters);
                condition = result.getCondition();
                index = result.getIndex();
                continue;
            }
            if (token.startsWith("Or")) {
                result = DocumentQueryParserUtil.or(args, index, token, methodName, representation, condition, converters);
                condition = result.getCondition();
                index = result.getIndex();
                continue;
            }
            condition = DocumentQueryParserUtil.toCondition(token, index, args, methodName, representation, converters);
            ++index;
        }
        return new ArtemisDocumentDeleteQuery(representation.getName(), condition);
    }
}

